/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.exceptions;

import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageAccessing;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.FineMessageSetBuilder;

public class FineRuntimeException
extends RuntimeException
implements FineMessageAccessing {
    private final FineMessageSet messageSet;

    public FineRuntimeException() {
        this.messageSet = FineMessageSetBuilder.empty();
    }

    public FineRuntimeException(String message, String ... traits) {
        super(message);
        this.messageSet = new FineMessageSetBuilder().withTraits(message, traits).build();
    }

    public FineRuntimeException(Throwable ex, String ... traits) {
        super(ex);
        this.messageSet = FineRuntimeException.toMsgSet(ex, traits);
    }

    public FineRuntimeException(String message, Throwable ex, String ... traits) {
        super(message, ex);
        this.messageSet = FineRuntimeException.toMsgSet(ex, traits);
    }

    public FineRuntimeException(FineMessage richMessage) {
        super(richMessage.getText());
        this.messageSet = new FineMessageSetBuilder().withMessage(richMessage).build();
    }

    public FineRuntimeException(FineMessage richMessage, String message) {
        super(message);
        this.messageSet = new FineMessageSetBuilder().withMessage(richMessage).build();
    }

    public FineRuntimeException(FineMessage richMessage, Throwable ex) {
        super(richMessage.getText(), ex);
        this.messageSet = new FineMessageSetBuilder().withMessage(richMessage).build();
    }

    public FineRuntimeException(FineMessage richMessage, String message, Throwable ex) {
        super(message, ex);
        this.messageSet = new FineMessageSetBuilder().withMessage(richMessage).build();
    }

    public FineRuntimeException(FineMessageSet messageSet) {
        super(messageSet.toString("; "));
        this.messageSet = new FineMessageSetBuilder().withSet(messageSet).build();
    }

    public FineRuntimeException(FineMessageSet messageSet, String message) {
        super(message);
        this.messageSet = new FineMessageSetBuilder().withSet(messageSet).build();
    }

    public FineRuntimeException(FineMessageSet messageSet, Throwable ex) {
        super(messageSet.toString("; "), ex);
        this.messageSet = new FineMessageSetBuilder().withSet(messageSet).build();
    }

    public FineRuntimeException(FineMessageSet messageSet, String message, Throwable ex) {
        super(message, ex);
        this.messageSet = new FineMessageSetBuilder().withSet(messageSet).build();
    }

    @Override
    public FineMessageSet getMessageSet() {
        return this.messageSet;
    }

    public String getSummary() {
        return this.messageSet.toString("; ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FineRuntimeException)) {
            return false;
        }
        FineRuntimeException that = (FineRuntimeException)o;
        return this.messageSet.equals(that.messageSet);
    }

    public int hashCode() {
        int result = this.getClass().getName().hashCode();
        result = 31 * result + this.messageSet.hashCode();
        return result;
    }

    private static FineMessageSet toMsgSet(Throwable ex, String[] traits) {
        FineMessageSetBuilder builder = new FineMessageSetBuilder();
        if (ex instanceof FineMessageAccessing) {
            FineMessageAccessing accessing = (FineMessageAccessing)((Object)ex);
            FineMessageSet messageSet = accessing.getMessageSet();
            builder.withSet(messageSet);
        }
        if (traits.length > 0) {
            builder.withTraits(ex.getMessage(), traits);
        }
        return builder.build();
    }
}

