/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.fine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.FineMessageSetImpl;
import org.crazyyak.dev.common.fine.TraitMap;

public class FineMessageSetBuilder {
    private static final FineMessageSet emptySet = new FineMessageSetImpl();
    private final List<FineMessage> messages = new ArrayList<FineMessage>();

    public static FineMessageSet empty() {
        return emptySet;
    }

    public FineMessageSet build() {
        return new FineMessageSetImpl(this.messages);
    }

    public FineMessageSetBuilder withMessage(FineMessage message) {
        if (message instanceof FineMessage) {
            this.messages.add(message);
        } else {
            this.messages.add(FineMessage.withAll(message.getText(), message.getId(), message.getTraitMap()));
        }
        return this;
    }

    public FineMessageSetBuilder withText(String text) {
        this.messages.add(FineMessage.withAll(text, null, TraitMap.empty()));
        return this;
    }

    public FineMessageSetBuilder withId(String text, String id) {
        this.messages.add(FineMessage.withAll(text, id, TraitMap.empty()));
        return this;
    }

    public FineMessageSetBuilder withTraits(String text, TraitMap traitMap) {
        this.messages.add(FineMessage.withAll(text, null, traitMap));
        return this;
    }

    public FineMessageSetBuilder withTraits(String text, Map<String, String> traitMapArg) {
        TraitMap traitMap = traitMapArg != null && traitMapArg.size() > 0 ? new TraitMap(traitMapArg) : TraitMap.empty();
        this.messages.add(FineMessage.withAll(text, null, traitMap));
        return this;
    }

    public FineMessageSetBuilder withTraits(String text, String ... traits) {
        TraitMap traitMap = traits != null && traits.length > 0 ? new TraitMap(traits) : TraitMap.empty();
        this.messages.add(FineMessage.withAll(text, null, traitMap));
        return this;
    }

    public FineMessageSetBuilder withAll(String text, String id, TraitMap traitMap) {
        this.messages.add(FineMessage.withAll(text, id, traitMap));
        return this;
    }

    public FineMessageSetBuilder withSet(FineMessageSet fineMsgSet) {
        if (fineMsgSet instanceof FineMessageSetImpl) {
            return this.withSet(fineMsgSet);
        }
        for (FineMessage message : fineMsgSet.getMessages()) {
            this.withMessage(message);
        }
        return this;
    }

    public FineMessageSetBuilder withImmutableSet(FineMessageSetImpl fineMsgSet) {
        if (fineMsgSet != null) {
            this.messages.addAll(fineMsgSet.getMessages());
        }
        return this;
    }
}

