package org.crazyyak.dev.common.fine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
* Created by jacobp on 7/29/2014.
*/
public class FineMessageSetBuilder {

  private static final FineMessageSet emptySet = new FineMessageSetImpl();

  public static FineMessageSet empty() {
    return emptySet;
  }

  private final List<FineMessage> messages = new ArrayList<>();

  public FineMessageSet build() {
    return new FineMessageSetImpl(messages);
  }

  public FineMessageSetBuilder withMessage(FineMessage message) {
    if (message instanceof FineMessage) {
      messages.add((FineMessage)message);
    } else {
      this.messages.add(FineMessage.withAll(
          message.getText(),
          message.getId(),
          message.getTraitMap()));
    }
    return this;
  }

  public FineMessageSetBuilder withText(String text) {
    messages.add(FineMessage.withAll(text, null, TraitMap.empty()));
    return this;
  }

  public FineMessageSetBuilder withId(String text, String id) {
    messages.add(FineMessage.withAll(text, id, TraitMap.empty()));
    return this;
  }

  public FineMessageSetBuilder withTraits(String text, TraitMap traitMap) {
    messages.add(FineMessage.withAll(text, null, traitMap));
    return this;
  }

  public FineMessageSetBuilder withTraits(String text, Map<String, String> traitMapArg) {
    TraitMap traitMap = (traitMapArg != null && traitMapArg.size() > 0) ? new TraitMap(traitMapArg) : TraitMap.empty();
    messages.add(FineMessage.withAll(text, null, traitMap));
    return this;
  }

  public FineMessageSetBuilder withTraits(String text, String...traits) {
    TraitMap traitMap = (traits != null && traits.length > 0) ? new TraitMap(traits) : TraitMap.empty();
    messages.add(FineMessage.withAll(text, null, traitMap));
    return this;
  }

  public FineMessageSetBuilder withAll(String text, String id, TraitMap traitMap) {
    messages.add(FineMessage.withAll(text, id, traitMap));
    return this;
  }

  public FineMessageSetBuilder withSet(FineMessageSet fineMsgSet) {
    if (fineMsgSet instanceof FineMessageSetImpl) {
      return withSet(fineMsgSet);
    }

    for (FineMessage message : fineMsgSet.getMessages()) {
      this.withMessage(message);
    }

    return this;
  }

  public FineMessageSetBuilder withImmutableSet(FineMessageSetImpl fineMsgSet) {
    if (fineMsgSet != null) {
      this.messages.addAll(fineMsgSet.getMessages());
    }
    return this;
  }
}
