/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.crazyyak.dev.common.BeanUtils;
import org.crazyyak.dev.common.ReflectUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class EqualsUtils {
    private EqualsUtils() {
    }

    public static <T> boolean objectsEqual(T valueA, T valueB) {
        if (valueA == valueB) {
            return true;
        }
        if (valueA == null || valueB == null) {
            return false;
        }
        return valueA.equals(valueB);
    }

    public static <T> boolean objectsNotEqual(T valueA, T valueB) {
        return !EqualsUtils.objectsEqual(valueA, valueB);
    }

    public static boolean datesEqual(Date dateA, Date dateB) {
        if (dateA == null && dateB == null) {
            return true;
        }
        if (dateA == null || dateB == null) {
            return false;
        }
        GregorianCalendar calA = new GregorianCalendar();
        calA.setTime(dateA);
        GregorianCalendar calB = new GregorianCalendar();
        calB.setTime(dateB);
        return calA.get(5) == calB.get(5) && calA.get(2) == calB.get(2) && calA.get(1) == calB.get(1);
    }

    public static boolean datesNotEqual(Date dateA, Date dateB) {
        return !EqualsUtils.datesEqual(dateA, dateB);
    }

    public static List<String> compare(Object objectA, Object objectB) {
        ArrayList<String> results = new ArrayList<String>();
        return EqualsUtils.compare(results, null, objectA, objectB, "root");
    }

    private static List<String> compare(List<String> results, Field field, Object objectA, Object objectB, String beanName) {
        Object valueB;
        Object valueA = field == null ? objectA : ReflectUtils.getFieldValue(objectA, field);
        Object object = valueB = field == null ? objectB : ReflectUtils.getFieldValue(objectB, field);
        if (valueA == valueB) {
            return results;
        }
        if (valueA == null) {
            return EqualsUtils.build(results, beanName, "Object A is null", "-some value-");
        }
        if (valueB == null) {
            return EqualsUtils.build(results, beanName, "-some value-", "Object B is null");
        }
        if (!valueA.getClass().equals(valueB.getClass())) {
            return EqualsUtils.build(results, beanName, valueA.getClass().getName(), valueB.getClass().getName());
        }
        Class<?> type = valueA.getClass();
        if (String.class.equals(type)) {
            System.out.print("");
        }
        if (EqualsUtils.isPrimitive(type)) {
            if (EqualsUtils.objectsEqual(valueA, valueB)) {
                return results;
            }
            return EqualsUtils.build(results, beanName, valueA, valueB);
        }
        if (type.isArray()) {
            List<Object> collectionA = Arrays.asList((Object[])valueA);
            List<Object> collectionB = Arrays.asList((Object[])valueB);
            return EqualsUtils.compareCollection(results, collectionA, collectionB, beanName);
        }
        if (valueA instanceof Collection && valueB instanceof Collection) {
            Collection collectionA = (Collection)valueA;
            Collection collectionB = (Collection)valueB;
            return EqualsUtils.compareCollection(results, new ArrayList(collectionA), new ArrayList(collectionB), beanName);
        }
        if (valueA instanceof Map && valueB instanceof Map) {
            return EqualsUtils.compareMaps(results, (Map)valueA, (Map)valueB, beanName);
        }
        List<Field> fields = ReflectUtils.getFields(valueA.getClass());
        for (Field nextField : fields) {
            boolean isStatic = Modifier.isStatic(nextField.getModifiers());
            boolean isTransient = Modifier.isTransient(nextField.getModifiers());
            if (isStatic || isTransient) continue;
            EqualsUtils.compare(results, nextField, valueA, valueB, beanName + "." + nextField.getName());
        }
        return results;
    }

    private static List<String> compareMaps(List<String> results, Map mapA, Map mapB, String beanName) {
        int countB;
        int countA = mapA.size();
        if (countA != (countB = mapB.size())) {
            EqualsUtils.build(results, beanName + ":count()", countA, countB);
        }
        Set keysA = mapA.keySet();
        Set keysB = mapB.keySet();
        List intersection = BeanUtils.intersection(keysA, keysB);
        for (Object key : intersection) {
            Object valueA = mapA.get(key);
            Object valueB = mapB.get(key);
            EqualsUtils.compare(results, null, valueA, valueB, beanName + "[" + key + "]");
        }
        for (Object key : mapA.keySet()) {
            if (intersection.contains(key)) continue;
            EqualsUtils.compare(results, null, "-contained-", "-missing-", beanName + "[" + key + "]");
        }
        for (Object key : mapB.keySet()) {
            if (intersection.contains(key)) continue;
            EqualsUtils.compare(results, null, "-missing-", "-contained-", beanName + "[" + key + "]");
        }
        return results;
    }

    private static List<String> build(List<String> result, String message, Object valueA, Object valueB) {
        String msg = String.format("%s:\n  %s\n  %s", message, valueA, valueB);
        result.add(msg);
        return result;
    }

    private static List<String> compareCollection(List<String> results, List listA, List listB, String beanName) {
        int i;
        int countB;
        int countA = listA.size();
        if (countA != (countB = listB.size())) {
            EqualsUtils.build(results, beanName + ":count()", countA, countB);
        }
        int max = Math.min(countA, countB);
        for (i = 0; i < max; ++i) {
            Object valueA = listA.get(i);
            Object valueB = listB.get(i);
            EqualsUtils.compare(results, null, valueA, valueB, beanName + "[" + i + "]");
        }
        for (i = max; i < listA.size(); ++i) {
            EqualsUtils.compare(results, null, "-contained-", "-missing-", beanName + "[" + i + "]");
        }
        for (i = max; i < listB.size(); ++i) {
            EqualsUtils.compare(results, null, "-missing-", "-contained-", beanName + "[" + i + "]");
        }
        return results;
    }

    private static boolean isPrimitive(Class type) {
        List<Class> types = Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, LocalDate.class, LocalTime.class, LocalDateTime.class);
        return type.isPrimitive() || types.contains(type);
    }
}

