package org.crazyyak.dev.common;

import org.joda.time.*;

import java.util.Calendar;

public class DateUtils {

  public static final DateTimeZone PDT = DateTimeZone.forID("America/Dawson");

  private static DateUtilsFactory factory = new DateUtilsFactory(null);
  
  private DateUtils() {
  }

  public static DateUtilsFactory newFactory(DateTimeZone timeZone) {
    return new DateUtilsFactory(timeZone);
  }

  public static LocalTime currentTime() {
    return factory.currentTime();
  }
  public static LocalDateTime currentDateTime() {
    return factory.currentDateTime();
  }
  public static LocalDate currentDate() {
    return factory.currentDate();
  }
  public static LocalDateTime midnightToday() {
    return factory.midnightToday();
  }



  public static LocalDate toLocalDate(String date) {
    return factory.toLocalDate(date);
  }
  public static LocalDate toLocalDate(long date) {
    return factory.toLocalDate(date);
  }
  public static LocalDate toLocalDate(java.util.Date date) {
    return factory.toLocalDate(date);
  }
  public static LocalDate toLocalDate(Calendar date) {
    return factory.toLocalDate(date);
  }
  public static LocalDate toLocalDate(LocalDateTime date) {
    return factory.toLocalDate(date);
  }
  public static LocalDate toLocalDate(DateTime date) {
    return factory.toLocalDate(date);
  }



  public static LocalTime toLocalTime(String date) {
    return factory.toLocalTime(date);
  }
  public static LocalTime toLocalTime(long date) {
    return factory.toLocalTime(date);
  }
  public static LocalTime toLocalTime(java.util.Date date) {
    return factory.toLocalTime(date);
  }
  public static LocalTime toLocalTime(Calendar date) {
    return factory.toLocalTime(date);
  }
  public static LocalTime toLocalTime(LocalDateTime date) {
    return factory.toLocalTime(date);
  }
  public static LocalTime toLocalTime(DateTime date) {
    return factory.toLocalTime(date);
  }



  public static LocalDateTime toLocalDateTime(String date) {
    return factory.toLocalDateTime(date);
  }
  public static LocalDateTime toLocalDateTime(long date) {
    return factory.toLocalDateTime(date);
  }
  public static LocalDateTime toLocalDateTime(java.util.Date date) {
    return factory.toLocalDateTime(date);
  }
  public static LocalDateTime toLocalDateTime(Calendar date) {
    return factory.toLocalDateTime(date);
  }
  public static LocalDateTime toLocalDateTime(LocalDate date) {
    return factory.toLocalDateTime(date);
  }
  public static LocalDateTime toLocalDateTime(DateTime date) {
    return factory.toLocalDateTime(date);
  }



  public static DateTime toDateTime(String date) {
    return factory.toDateTime(date);
  }
  public static DateTime toDateTime(long date) {
    return factory.toDateTime(date);
  }
  public static DateTime toDateTime(LocalDate date) {
    return factory.toDateTime(date);
  }
  public static DateTime toDateTime(LocalDateTime date) {
    return factory.toDateTime(date);
  }
  public static DateTime toDateTime(java.util.Date date) {
    return factory.toDateTime(date);
  }
  public static DateTime toDateTime(Calendar date) {
    return factory.toDateTime(date);
  }
}
