/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.util.Calendar;
import java.util.Date;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class DateUtilsFactory {
    private final DateTimeZone defaultTimeZone;

    public DateUtilsFactory(DateTimeZone defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    public LocalTime currentTime() {
        return new LocalTime(this.defaultTimeZone);
    }

    public LocalDateTime currentDateTime() {
        return new LocalDateTime(this.defaultTimeZone);
    }

    public LocalDate currentDate() {
        return new LocalDate(this.defaultTimeZone);
    }

    public LocalDateTime midnightToday() {
        return new LocalDate(this.defaultTimeZone).toLocalDateTime(LocalTime.MIDNIGHT);
    }

    public LocalDate toLocalDate(String date) {
        ExceptionUtils.assertNotNull(date, "date");
        date = date.replace('/', '-');
        if (date.contains(" ")) {
            date = date.substring(0, date.indexOf(32));
            return new LocalDate((Object)date, this.defaultTimeZone);
        }
        if (date.contains("T")) {
            date = date.substring(0, date.indexOf(84));
            return new LocalDate((Object)date, this.defaultTimeZone);
        }
        return new LocalDate((Object)date, this.defaultTimeZone);
    }

    public LocalDate toLocalDate(long date) {
        if (date <= 0L) {
            throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
        }
        return new LocalDate(date, this.defaultTimeZone);
    }

    public LocalDate toLocalDate(Date date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new LocalDate((Object)date, this.defaultTimeZone);
    }

    public LocalDate toLocalDate(Calendar date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new LocalDate((Object)date, this.defaultTimeZone);
    }

    public LocalDate toLocalDate(LocalDateTime date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toLocalDate();
    }

    public LocalDate toLocalDate(DateTime date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toLocalDate();
    }

    public LocalTime toLocalTime(String date) {
        ExceptionUtils.assertNotNull(date, "date");
        date = date.replace('/', '-');
        if (!date.contains("-")) {
            return new LocalTime((Object)date, this.defaultTimeZone);
        }
        if (date.contains(" ")) {
            date = date.replace(" ", "T");
            return new LocalDateTime((Object)date, this.defaultTimeZone).toLocalTime();
        }
        if (date.contains("T")) {
            return new LocalDateTime((Object)date, this.defaultTimeZone).toLocalTime();
        }
        return LocalTime.MIDNIGHT;
    }

    public LocalTime toLocalTime(long date) {
        if (date <= 0L) {
            throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
        }
        return new LocalTime(date, this.defaultTimeZone);
    }

    public LocalTime toLocalTime(Date date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new LocalTime((Object)date, this.defaultTimeZone);
    }

    public LocalTime toLocalTime(Calendar date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new LocalTime((Object)date, this.defaultTimeZone);
    }

    public LocalTime toLocalTime(LocalDateTime date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toLocalTime();
    }

    public LocalTime toLocalTime(DateTime date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toLocalTime();
    }

    public LocalDateTime toLocalDateTime(String date) {
        ExceptionUtils.assertNotNull(date, "date");
        date = date.replace('/', '-');
        if (date.contains(" ")) {
            date = date.replace(" ", "T");
        } else if (!date.contains("T")) {
            date = date + "T" + LocalTime.MIDNIGHT;
        }
        return new LocalDateTime((Object)date, this.defaultTimeZone);
    }

    public LocalDateTime toLocalDateTime(long date) {
        if (date <= 0L) {
            throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
        }
        return new LocalDateTime(date, this.defaultTimeZone);
    }

    public LocalDateTime toLocalDateTime(Date date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new LocalDateTime((Object)date, this.defaultTimeZone);
    }

    public LocalDateTime toLocalDateTime(Calendar date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new LocalDateTime((Object)date, this.defaultTimeZone);
    }

    public LocalDateTime toLocalDateTime(LocalDate date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toLocalDateTime(LocalTime.MIDNIGHT);
    }

    public LocalDateTime toLocalDateTime(DateTime date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toLocalDateTime();
    }

    public DateTime toDateTime(String date) {
        ExceptionUtils.assertNotNull(date, "date");
        date = date.replace('/', '-');
        if (date.contains(" ")) {
            date = date.replace(" ", "T");
            return new DateTime((Object)date, this.defaultTimeZone);
        }
        if (date.contains("T")) {
            return new DateTime((Object)date, this.defaultTimeZone);
        }
        return new LocalDate((Object)date, this.defaultTimeZone).toDateTime(LocalTime.MIDNIGHT);
    }

    public DateTime toDateTime(long date) {
        if (date <= 0L) {
            throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
        }
        return new DateTime(date, this.defaultTimeZone);
    }

    public DateTime toDateTime(LocalDate date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toDateTime(LocalTime.MIDNIGHT, this.defaultTimeZone);
    }

    public DateTime toDateTime(LocalDateTime date) {
        ExceptionUtils.assertNotNull(date, "date");
        return date.toDateTime(this.defaultTimeZone);
    }

    public DateTime toDateTime(Date date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new DateTime(date.getTime(), this.defaultTimeZone);
    }

    public DateTime toDateTime(Calendar date) {
        ExceptionUtils.assertNotNull(date, "date");
        return new DateTime(date.getTime().getTime(), this.defaultTimeZone);
    }
}

