package org.crazyyak.dev.common;

import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.joda.time.*;

import java.util.Calendar;

public class DateUtilsFactory {

  private final DateTimeZone defaultTimeZone;

  public DateUtilsFactory(DateTimeZone defaultTimeZone) {
    this.defaultTimeZone = defaultTimeZone;
  }

  public LocalTime currentTime() {
    return new LocalTime(defaultTimeZone);
  }
  public LocalDateTime currentDateTime() {
    return new LocalDateTime(defaultTimeZone);
  }
  public LocalDate currentDate() {
    return new LocalDate(defaultTimeZone);
  }
  public LocalDateTime midnightToday() {
    return new LocalDate(defaultTimeZone).toLocalDateTime(LocalTime.MIDNIGHT);
  }



  public LocalDate toLocalDate(String date) {

    ExceptionUtils.assertNotNull(date, "date");
    date = date.replace('/', '-');

    if (date.contains(" ")) {
      date = date.substring(0, date.indexOf(' '));
      return new LocalDate(date, defaultTimeZone);

    } else if (date.contains("T")) {
      date = date.substring(0, date.indexOf('T'));
      return new LocalDate(date, defaultTimeZone);

    } else {
      return new LocalDate(date, defaultTimeZone);
    }
  }
  public LocalDate toLocalDate(long date) {
    if (date <= 0) {
      throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
    }
    return new LocalDate(date, defaultTimeZone);
  }
  public LocalDate toLocalDate(java.util.Date date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new LocalDate(date, defaultTimeZone);
  }
  public LocalDate toLocalDate(Calendar date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new LocalDate(date, defaultTimeZone);
  }
  public LocalDate toLocalDate(LocalDateTime date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toLocalDate();
  }
  public LocalDate toLocalDate(DateTime date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toLocalDate();
  }



  public LocalTime toLocalTime(String date) {

    ExceptionUtils.assertNotNull(date, "date");
    date = date.replace('/', '-');

    if (date.contains("-") == false) {
      return new LocalTime(date, defaultTimeZone);

    } else if (date.contains(" ")) {
      date = date.replace(" ", "T");
      return new LocalDateTime(date, defaultTimeZone).toLocalTime();

    } else if (date.contains("T")) {
      return new LocalDateTime(date, defaultTimeZone).toLocalTime();

    } else {
      return LocalTime.MIDNIGHT;
    }
  }
  public LocalTime toLocalTime(long date) {
    if (date <= 0) {
      throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
    }
    return new LocalTime(date, defaultTimeZone);
  }
  public LocalTime toLocalTime(java.util.Date date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new LocalTime(date, defaultTimeZone);
  }
  public LocalTime toLocalTime(Calendar date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new LocalTime(date, defaultTimeZone);
  }
  public LocalTime toLocalTime(LocalDateTime date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toLocalTime();
  }
  public LocalTime toLocalTime(DateTime date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toLocalTime();
  }



  public LocalDateTime toLocalDateTime(String date) {

    ExceptionUtils.assertNotNull(date, "date");
    date = date.replace('/', '-');

    if (date.contains(" ")) {
      date = date.replace(" ", "T");

    } else if (date.contains("T") == false) {
      date = date + "T" + LocalTime.MIDNIGHT;
    }

    return new LocalDateTime(date, defaultTimeZone);
  }
  public LocalDateTime toLocalDateTime(long date) {
    if (date <= 0) {
      throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
    }
    return new LocalDateTime(date, defaultTimeZone);
  }
  public LocalDateTime toLocalDateTime(java.util.Date date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new LocalDateTime(date, defaultTimeZone);
  }
  public LocalDateTime toLocalDateTime(Calendar date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new LocalDateTime(date, defaultTimeZone);
  }
  public LocalDateTime toLocalDateTime(LocalDate date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toLocalDateTime(LocalTime.MIDNIGHT);
  }
  public LocalDateTime toLocalDateTime(DateTime date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toLocalDateTime();
  }



  public DateTime toDateTime(String date) {

    ExceptionUtils.assertNotNull(date, "date");
    date = date.replace('/', '-');

    if (date.contains(" ")) {
      date = date.replace(" ", "T");
      return new DateTime(date, defaultTimeZone);

    } else if (date.contains("T")) {
      return new DateTime(date, defaultTimeZone);

    } else {
      return new LocalDate(date, defaultTimeZone).toDateTime(LocalTime.MIDNIGHT);

    }
  }
  public DateTime toDateTime(long date) {
    if (date <= 0) {
      throw new IllegalArgumentException("The value \"date\" must be greater than zero.");
    }
    return new DateTime(date, defaultTimeZone);
  }
  public DateTime toDateTime(LocalDate date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toDateTime(LocalTime.MIDNIGHT, defaultTimeZone);
  }
  public DateTime toDateTime(LocalDateTime date) {
    ExceptionUtils.assertNotNull(date, "date");
    return date.toDateTime(defaultTimeZone);
  }
  public DateTime toDateTime(java.util.Date date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new DateTime(date.getTime(), defaultTimeZone);
  }
  public DateTime toDateTime(Calendar date) {
    ExceptionUtils.assertNotNull(date, "date");
    return new DateTime(date.getTime().getTime(), defaultTimeZone);
  }
}
