/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.crazyyak.dev.common.BeanUtils;
import org.crazyyak.dev.common.ComparisonResults;
import org.crazyyak.dev.common.ReflectUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class EqualsUtils {
    private EqualsUtils() {
    }

    public static <T> boolean objectsEqual(T valueA, T valueB) {
        if (valueA == valueB) {
            return true;
        }
        if (valueA == null || valueB == null) {
            return false;
        }
        return valueA.equals(valueB);
    }

    public static <T> boolean objectsNotEqual(T valueA, T valueB) {
        return !EqualsUtils.objectsEqual(valueA, valueB);
    }

    public static boolean datesEqual(Date dateA, Date dateB) {
        if (dateA == null && dateB == null) {
            return true;
        }
        if (dateA == null || dateB == null) {
            return false;
        }
        GregorianCalendar calA = new GregorianCalendar();
        calA.setTime(dateA);
        GregorianCalendar calB = new GregorianCalendar();
        calB.setTime(dateB);
        return calA.get(5) == calB.get(5) && calA.get(2) == calB.get(2) && calA.get(1) == calB.get(1);
    }

    public static boolean datesNotEqual(Date dateA, Date dateB) {
        return !EqualsUtils.datesEqual(dateA, dateB);
    }

    public static boolean bigDecimalsEqual(BigDecimal valueA, BigDecimal valueB) {
        if (valueA == valueB) {
            return true;
        }
        if (valueA == null || valueB == null) {
            return true;
        }
        int commonScale = Math.min(valueA.scale(), valueB.scale());
        valueA = valueA.setScale(commonScale, RoundingMode.HALF_EVEN);
        valueB = valueB.setScale(commonScale, RoundingMode.HALF_EVEN);
        return valueA.equals(valueB);
    }

    public static boolean bigDecimalsNotEqual(BigDecimal valueA, BigDecimal valueB) {
        return !EqualsUtils.bigDecimalsEqual(valueA, valueB);
    }

    public static ComparisonResults compare(Object objectA, Object objectB) {
        ComparisonResults.Builder builder = ComparisonResults.builder();
        return EqualsUtils.compare(builder, null, objectA, objectB, "root").build();
    }

    private static ComparisonResults.Builder compare(ComparisonResults.Builder builder, Field field, Object objectA, Object objectB, String beanName) {
        Object valueB;
        Object valueA = field == null ? objectA : ReflectUtils.getFieldValue(objectA, field);
        Object object = valueB = field == null ? objectB : ReflectUtils.getFieldValue(objectB, field);
        if (valueA == valueB) {
            return builder;
        }
        if (valueA == null) {
            return builder.add(beanName, null, valueB, ComparisonResults.VALUE_A_IS_NULL);
        }
        if (valueB == null) {
            return builder.add(beanName, valueA, null, ComparisonResults.VALUE_B_IS_NULL);
        }
        if (valueA instanceof Collection && valueB instanceof Collection) {
            Collection collectionA = (Collection)valueA;
            Collection collectionB = (Collection)valueB;
            return EqualsUtils.compareCollection(builder, collectionA, collectionB, beanName);
        }
        if (valueA instanceof Map && valueB instanceof Map) {
            return EqualsUtils.compareMaps(builder, (Map)valueA, (Map)valueB, beanName);
        }
        if (!valueA.getClass().equals(valueB.getClass())) {
            return builder.add(beanName, valueA.getClass(), valueB.getClass(), ComparisonResults.CLASSES_DIFFERENT);
        }
        Class<?> type = valueA.getClass();
        if (EqualsUtils.isPrimitive(type)) {
            boolean equal = EqualsUtils.objectsEqual(valueA, valueB);
            return equal ? builder : builder.add(beanName, valueA, valueB, ComparisonResults.NOT_EQUAL);
        }
        if (valueA instanceof Object[] && valueB instanceof Object[]) {
            List<Object> collectionA = Arrays.asList((Object[])valueA);
            List<Object> collectionB = Arrays.asList((Object[])valueB);
            return EqualsUtils.compareCollection(builder, collectionA, collectionB, beanName);
        }
        List<Field> fields = ReflectUtils.getFields(valueA.getClass());
        for (Field nextField : fields) {
            boolean isStatic = Modifier.isStatic(nextField.getModifiers());
            boolean isTransient = Modifier.isTransient(nextField.getModifiers());
            if (isStatic || isTransient) continue;
            EqualsUtils.compare(builder, nextField, valueA, valueB, beanName + "." + nextField.getName());
        }
        return builder;
    }

    private static ComparisonResults.Builder compareMaps(ComparisonResults.Builder builder, Map mapA, Map mapB, String beanName) {
        int countB;
        int countA = mapA.size();
        if (countA != (countB = mapB.size())) {
            builder.add(beanName + ":count()", countA, countB, ComparisonResults.SIZE);
        }
        Set keysA = mapA.keySet();
        Set keysB = mapB.keySet();
        List intersection = BeanUtils.intersection(keysA, keysB);
        for (Object key : intersection) {
            Object valueA = mapA.get(key);
            Object valueB = mapB.get(key);
            EqualsUtils.compare(builder, null, valueA, valueB, beanName + "[" + key + "]");
        }
        for (Object key : mapA.keySet()) {
            if (intersection.contains(key)) continue;
            builder.add(beanName + "[" + key + "]", mapA.get(key), null, ComparisonResults.MISSING_B);
        }
        for (Object key : mapB.keySet()) {
            if (intersection.contains(key)) continue;
            builder.add(beanName + "[" + key + "]", null, mapA.get(key), ComparisonResults.MISSING_A);
        }
        return builder;
    }

    private static ComparisonResults.Builder compareCollection(ComparisonResults.Builder builder, Collection<?> collectionA, Collection<?> collectionB, String beanName) {
        int i;
        int countB;
        ArrayList listA = new ArrayList(collectionA);
        ArrayList listB = new ArrayList(collectionB);
        int countA = listA.size();
        if (countA != (countB = listB.size())) {
            builder.add(beanName + ":count()", countA, countB, ComparisonResults.SIZE);
        }
        int max = Math.min(countA, countB);
        for (i = 0; i < max; ++i) {
            Object valueA = listA.get(i);
            Object valueB = listB.get(i);
            EqualsUtils.compare(builder, null, valueA, valueB, beanName + "[" + i + "]");
        }
        for (i = max; i < listA.size(); ++i) {
            builder.add(beanName + "[" + i + "]", listA.get(i), null, ComparisonResults.MISSING_B);
        }
        for (i = max; i < listB.size(); ++i) {
            builder.add(beanName + "[" + i + "]", null, listB.get(i), ComparisonResults.MISSING_A);
        }
        return builder;
    }

    private static boolean isPrimitive(Class type) {
        List<Class> types = Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, LocalDate.class, LocalTime.class, LocalDateTime.class);
        return type.isPrimitive() || types.contains(type);
    }
}

