/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.fine;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.crazyyak.dev.common.BeanUtils;

public class TraitMap
implements Serializable {
    private static final TraitMap empty = new TraitMap(new String[0]);
    private final KeyType keyType;
    private final Map<String, String> map;

    public static TraitMap empty() {
        return empty;
    }

    public TraitMap(Map<?, ?> givenMap) {
        this(null, givenMap);
    }

    public TraitMap(KeyType keyType, Map<?, ?> givenMap) {
        KeyType keyType2 = this.keyType = keyType == null ? KeyType.UPPER : keyType;
        if (givenMap == null) {
            this.map = Collections.emptyMap();
            return;
        }
        TreeMap<String, String> localMap = new TreeMap<String, String>();
        for (Map.Entry<?, ?> entry : givenMap.entrySet()) {
            if (entry.getKey() == null) continue;
            String key = this.fixCase(entry.getKey().toString());
            Object value = entry.getValue();
            if (value == null) {
                localMap.put(key, null);
                continue;
            }
            localMap.put(key, value.toString());
        }
        this.map = Collections.unmodifiableSortedMap(localMap);
    }

    public TraitMap(String ... traitStrings) {
        this((KeyType)null, traitStrings);
    }

    public TraitMap(KeyType keyType, String ... traitStrings) {
        this(keyType, BeanUtils.toMap(traitStrings));
    }

    public TraitMap(Collection<String> traitStrings) {
        this(null, BeanUtils.toMap(traitStrings));
    }

    public TraitMap(KeyType keyType, Collection<String> traitStrings) {
        this(keyType, BeanUtils.toMap(traitStrings));
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public TraitMap add(TraitMap traitMapArg) {
        HashMap<String, String> localMap = new HashMap<String, String>(this.map);
        localMap.putAll(traitMapArg.getMap());
        return new TraitMap(this.keyType, localMap);
    }

    public TraitMap add(Map<?, ?> traitMapArg) {
        if (traitMapArg == null || traitMapArg.isEmpty()) {
            return this;
        }
        HashMap<String, String> localMap = new HashMap<String, String>(this.map);
        for (Map.Entry<?, ?> entry : traitMapArg.entrySet()) {
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) {
                localMap.put(entry.getKey().toString(), null);
                continue;
            }
            localMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return new TraitMap(this.keyType, localMap);
    }

    public TraitMap remove(Collection<String> traits) {
        if (traits == null || traits.isEmpty()) {
            return this;
        }
        HashMap<String, String> localMap = new HashMap<String, String>(this.map);
        for (String trait : traits) {
            localMap.remove(trait);
        }
        return new TraitMap(this.keyType, localMap);
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.map.isEmpty();
    }

    public int getSize() {
        return this.map.size();
    }

    public boolean hasTrait(String key) {
        return key != null && this.map.containsKey(this.fixCase(key));
    }

    public boolean hasValue(String key, String checkValue) {
        if (key == null) {
            return false;
        }
        String value = this.map.get(this.fixCase(key));
        if (checkValue == null) {
            return value == null;
        }
        return checkValue.equals(value);
    }

    public String getValue(String key) {
        return key == null ? null : this.map.get(this.fixCase(key));
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            if (entry.getValue() == null) {
                sb.append("null");
            } else {
                sb.append("\"");
                sb.append(entry.getValue());
                sb.append("\"");
            }
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraitMap that = (TraitMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.getText();
    }

    private String fixCase(String value) {
        if (value == null) {
            return null;
        }
        if (KeyType.NATURAL.equals((Object)this.keyType)) {
            return value;
        }
        if (KeyType.UPPER.equals((Object)this.keyType)) {
            return value.toUpperCase();
        }
        if (KeyType.LOWER.equals((Object)this.keyType)) {
            return value.toLowerCase();
        }
        String msg = String.format("The key type \"%s\" is not supported.", new Object[]{this.keyType});
        throw new UnsupportedOperationException(msg);
    }

    public static enum KeyType {
        NATURAL,
        UPPER,
        LOWER;

    }
}

