/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.crazyyak.dev.common.DateUtilsFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class DateUtils {
    public static final DateTimeZone PDT = DateTimeZone.forID((String)"America/Dawson");
    private static DateUtilsFactory factory = new DateUtilsFactory(null);

    private DateUtils() {
    }

    public static DateUtilsFactory newFactory(DateTimeZone timeZone) {
        return new DateUtilsFactory(timeZone);
    }

    public static LocalTime currentTime() {
        return factory.currentTime();
    }

    public static LocalDateTime currentDateTime() {
        return factory.currentDateTime();
    }

    public static LocalDate currentDate() {
        return factory.currentDate();
    }

    public static LocalDateTime midnightToday() {
        return factory.midnightToday();
    }

    public static LocalDate toLocalDate(Object date) {
        return factory.toLocalDate(date);
    }

    public static LocalDate toLocalDate(String date) {
        return factory.toLocalDate(date);
    }

    public static LocalDate toLocalDate(long date) {
        return factory.toLocalDate(date);
    }

    public static LocalDate toLocalDate(Date date) {
        return factory.toLocalDate(date);
    }

    public static LocalDate toLocalDate(Calendar date) {
        return factory.toLocalDate(date);
    }

    public static LocalDate toLocalDate(LocalDateTime date) {
        return factory.toLocalDate(date);
    }

    public static LocalDate toLocalDate(DateTime date) {
        return factory.toLocalDate(date);
    }

    public static LocalDate toLocalDate(int year, int month, int day) {
        return factory.toLocalDate(year, month, day);
    }

    public static LocalTime toLocalTime(Object date) {
        return factory.toLocalTime(date);
    }

    public static LocalTime toLocalTime(String date) {
        return factory.toLocalTime(date);
    }

    public static LocalTime toLocalTime(long date) {
        return factory.toLocalTime(date);
    }

    public static LocalTime toLocalTime(Date date) {
        return factory.toLocalTime(date);
    }

    public static LocalTime toLocalTime(Calendar date) {
        return factory.toLocalTime(date);
    }

    public static LocalTime toLocalTime(LocalDateTime date) {
        return factory.toLocalTime(date);
    }

    public static LocalTime toLocalTime(DateTime date) {
        return factory.toLocalTime(date);
    }

    public static LocalTime toLocalTime(int hourOfDay, int minuteOfHour) {
        return factory.toLocalTime(hourOfDay, minuteOfHour, 0, 0);
    }

    public static LocalTime toLocalTime(int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return factory.toLocalTime(hourOfDay, minuteOfHour, secondOfMinute, 0);
    }

    public static LocalTime toLocalTime(int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return factory.toLocalTime(hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public static LocalDateTime toLocalDateTime(Object date) {
        return factory.toLocalDateTime(date);
    }

    public static LocalDateTime toLocalDateTime(String date) {
        return factory.toLocalDateTime(date);
    }

    public static LocalDateTime toLocalDateTime(long date) {
        return factory.toLocalDateTime(date);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return factory.toLocalDateTime(date);
    }

    public static LocalDateTime toLocalDateTime(Calendar date) {
        return factory.toLocalDateTime(date);
    }

    public static LocalDateTime toLocalDateTime(LocalDate date) {
        return factory.toLocalDateTime(date);
    }

    public static LocalDateTime toLocalDateTime(DateTime date) {
        return factory.toLocalDateTime(date);
    }

    public static LocalDateTime toLocalDateTime(int year, int monthOfYear, int dayOfMonth) {
        return factory.toLocalDateTime(year, monthOfYear, dayOfMonth, 0, 0, 0, 0);
    }

    public static LocalDateTime toLocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour) {
        return factory.toLocalDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, 0, 0);
    }

    public static LocalDateTime toLocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return factory.toLocalDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, 0);
    }

    public static LocalDateTime toLocalDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return factory.toLocalDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public static DateTime toDateTime(Object date) {
        return factory.toDateTime(date);
    }

    public static DateTime toDateTime(String date) {
        return factory.toDateTime(date);
    }

    public static DateTime toDateTime(long date) {
        return factory.toDateTime(date);
    }

    public static DateTime toDateTime(LocalDate date) {
        return factory.toDateTime(date);
    }

    public static DateTime toDateTime(LocalDateTime date) {
        return factory.toDateTime(date);
    }

    public static DateTime toDateTime(Date date) {
        return factory.toDateTime(date);
    }

    public static DateTime toDateTime(Calendar date) {
        return factory.toDateTime(date);
    }

    public static DateTime toDateTime(int year, int monthOfYear, int dayOfMonth) {
        return factory.toDateTime(year, monthOfYear, dayOfMonth, 0, 0, 0, 0);
    }

    public static DateTime toDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour) {
        return factory.toDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, 0, 0);
    }

    public static DateTime toDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        return factory.toDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, 0);
    }

    public static DateTime toDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        return factory.toDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
    }

    public static boolean datesEqual(Date dateA, Date dateB) {
        if (dateA == null && dateB == null) {
            return true;
        }
        if (dateA == null || dateB == null) {
            return false;
        }
        GregorianCalendar calA = new GregorianCalendar();
        calA.setTime(dateA);
        GregorianCalendar calB = new GregorianCalendar();
        calB.setTime(dateB);
        return calA.get(5) == calB.get(5) && calA.get(2) == calB.get(2) && calA.get(1) == calB.get(1);
    }

    public static boolean datesNotEqual(Date dateA, Date dateB) {
        return !DateUtils.datesEqual(dateA, dateB);
    }
}

