/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class LogUtils {
    public static final Level DEFAULT_LEVEL = Level.WARN;
    public static final String DEFAULT_PATTERN = "%-5p: %d{MM-dd-yy HH:mm:ss} [%t] %c %x- %m%n";

    public static File getDefaultLogFile() {
        return new File("/var/opt/tomcat7/bill-minder-app.log");
    }

    public static void initAppenders() {
        LogUtils.initConsoleAppender(DEFAULT_LEVEL, DEFAULT_PATTERN);
        LogUtils.initDailyRollingFileAppender(DEFAULT_LEVEL, DEFAULT_PATTERN, LogUtils.getDefaultLogFile());
    }

    public static void initConsoleAppender() {
        LogUtils.initConsoleAppender(DEFAULT_LEVEL, DEFAULT_PATTERN);
    }

    public static void initConsoleAppender(Level level, String pattern) {
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout(pattern));
        consoleAppender.setThreshold((Priority)level);
        Logger.getRootLogger().addAppender((Appender)consoleAppender);
        String msg = String.format("%s configured with log level %s.", ConsoleAppender.class.getSimpleName(), level);
        LogUtils.info(LogUtils.class, msg);
    }

    public static void initDailyRollingFileAppender() {
        LogUtils.initDailyRollingFileAppender(DEFAULT_LEVEL, DEFAULT_PATTERN, LogUtils.getDefaultLogFile());
    }

    public static void initDailyRollingFileAppender(Level level, String pattern, File file) {
        try {
            if (file.getParentFile().exists()) {
                DailyRollingFileAppender fileAppender = new DailyRollingFileAppender((Layout)new PatternLayout(pattern), file.getAbsolutePath(), "yyyy-MM-dd");
                fileAppender.setThreshold((Priority)level);
                Logger.getRootLogger().addAppender((Appender)fileAppender);
                String msg = String.format("%s configured with log level %s appending to %s.", DailyRollingFileAppender.class.getSimpleName(), level, file.getAbsolutePath());
                LogUtils.info(LogUtils.class, msg);
            } else {
                String msg = String.format("Unable to configure %s, file not found: %s", DailyRollingFileAppender.class.getSimpleName(), file.getParentFile().getAbsolutePath());
                LogUtils.fatal(LogUtils.class, msg);
            }
        }
        catch (IOException ex) {
            LogUtils.fatal(LogUtils.class, "Unable to configure " + DailyRollingFileAppender.class.getSimpleName(), ex);
        }
    }

    public static void info(Class type, String msg) {
        Logger.getLogger((Class)type).info((Object)msg);
    }

    public static void info(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).info((Object)msg, ex);
    }

    public static void warn(Class type, String msg) {
        Logger.getLogger((Class)type).warn((Object)msg);
    }

    public static void warn(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).warn((Object)msg, ex);
    }

    public static void fatal(Class type, String msg) {
        Logger.getLogger((Class)type).fatal((Object)msg);
    }

    public static void fatal(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).fatal((Object)msg, ex);
    }

    public static void trace(Class type, String msg) {
        Logger.getLogger((Class)type).trace((Object)msg);
    }

    public static void trace(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).trace((Object)msg, ex);
    }

    public static void debug(Class type, String msg) {
        Logger.getLogger((Class)type).debug((Object)msg);
    }

    public static void debug(Class type, String msg, Throwable ex) {
        Logger.getLogger((Class)type).debug((Object)msg, ex);
    }
}

