/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;

public class ReflectUtils {
    private ReflectUtils() {
        int i = 2;
    }

    public static Field getField(Class<?> type, String name) {
        while (type != null) {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static Object getFieldValue(Object entity, Field field) {
        ExceptionUtils.assertNotNull(entity, "entity");
        ExceptionUtils.assertNotNull(field, "field");
        if (entity == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(entity);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception reflecting field's value", ex);
        }
    }

    public static void setPropertyValue(Object entity, Field field, Object value) {
        ExceptionUtils.assertNotNull(field, "field");
        Method setter = ReflectUtils.getWriteMethod(field.getDeclaringClass(), field.getName(), field.getType());
        if (setter == null) {
            ReflectUtils.setFieldValue(entity, field, value);
            return;
        }
        try {
            setter.setAccessible(true);
            setter.invoke(entity, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception reflecting field's value", ex);
        }
    }

    public static void setFieldValue(Object entity, Field field, Object value) {
        ExceptionUtils.assertNotNull(field, "field");
        try {
            field.setAccessible(true);
            field.set(entity, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception reflecting field's value", ex);
        }
    }

    public static Method getMethod(Class<?> type, String methodName, Class ... parameterTypes) {
        try {
            return type.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getWriteMethod(Class<?> type, String propertyName, Class argType) {
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            return type.getMethod(methodName, argType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getReadMethod(Class<?> type, String propertyName) {
        String[] prefixes;
        for (String prefix : prefixes = new String[]{"get", "is", "was", "has"}) {
            String methodName = prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            try {
                return type.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    public static String getName(Object object) {
        return object == null ? null : object.getClass().getSimpleName();
    }

    public static String getQualifiedMethodName(int offset) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StackTraceElement element = elements[offset + 2];
        return element.getClassName() + "." + element.getMethodName();
    }

    public static String getMethodName(int offset) {
        return ReflectUtils.getElement(offset + 1).getMethodName();
    }

    public static String getClassName(int offset) {
        return ReflectUtils.getElement(offset + 1).getClassName();
    }

    public static StackTraceElement getElement(int offset) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        return elements[offset + 2];
    }

    public static <T> T[] toArray(Class<T> type, Collection<T> collection) {
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        int i = 0;
        for (T t : collection) {
            array[i] = t;
            ++i;
        }
        return array;
    }

    public static <T> T getValueOf(Class<T> type, String stringValue) {
        try {
            if (stringValue == null) {
                return null;
            }
            String methodName = "valueOf";
            Method method = ReflectUtils.getMethod(type, methodName, String.class);
            if (method == null) {
                String msg = String.format("The method %s.%s does not exist.", type.getName(), "valueOf");
                throw new IllegalArgumentException(msg);
            }
            return (T)method.invoke(null, stringValue);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Field> getFields(Class type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (type != null) {
            Collections.addAll(fields, type.getDeclaredFields());
            type = type.getSuperclass();
        }
        return fields;
    }

    public static List<Field> getNonStaticFields(Class type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (type != null) {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
            type = type.getSuperclass();
        }
        return fields;
    }

    public static List<Field> getStaticFields(Class type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (type != null) {
            for (Field field : type.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
            type = type.getSuperclass();
        }
        return fields;
    }

    public static Field getAnnotatedField(Object entity, Class<? extends Annotation> annotation) {
        for (Field field : ReflectUtils.getFields(entity.getClass())) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return field;
        }
        return null;
    }
}

