/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.exceptions;

import org.crazyyak.dev.common.exceptions.FineRuntimeException;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.net.HttpStatusCode;

public class ApiException
extends FineRuntimeException {
    private final HttpStatusCode httpStatusCode;

    public ApiException(HttpStatusCode httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, String message, String ... traits) {
        super(message, traits);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, Throwable ex, String ... traits) {
        super(ex, traits);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, String message, Throwable ex, String ... traits) {
        super(message, ex, traits);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage) {
        super(richMessage);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage, Throwable ex) {
        super(richMessage, ex, new String[0]);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet) {
        super(messageSet);
        this.httpStatusCode = httpStatusCode;
    }

    public ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet, Throwable ex) {
        super(messageSet, ex, new String[0]);
        this.httpStatusCode = httpStatusCode;
    }

    public int getStatusCode() {
        return this.httpStatusCode == null ? -1 : this.httpStatusCode.getCode();
    }

    public HttpStatusCode getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static ApiException forbidden() {
        return new ApiException(HttpStatusCode.FORBIDDEN);
    }

    public static ApiException forbidden(String message, String ... traits) {
        return new ApiException(HttpStatusCode.FORBIDDEN, message, traits);
    }

    public static ApiException forbidden(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.FORBIDDEN, ex, traits);
    }

    public static ApiException forbidden(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.FORBIDDEN, message, ex, traits);
    }

    public static ApiException forbidden(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.FORBIDDEN, richMessage);
    }

    public static ApiException forbidden(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.FORBIDDEN, richMessage, ex);
    }

    public static ApiException forbidden(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.FORBIDDEN, messageSet);
    }

    public static ApiException forbidden(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.FORBIDDEN, messageSet, ex);
    }

    public static ApiException unauthorized() {
        return new ApiException(HttpStatusCode.UNAUTHORIZED);
    }

    public static ApiException unauthorized(String message, String ... traits) {
        return new ApiException(HttpStatusCode.UNAUTHORIZED, message, traits);
    }

    public static ApiException unauthorized(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.UNAUTHORIZED, ex, traits);
    }

    public static ApiException unauthorized(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.UNAUTHORIZED, message, ex, traits);
    }

    public static ApiException unauthorized(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.UNAUTHORIZED, richMessage);
    }

    public static ApiException unauthorized(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.UNAUTHORIZED, richMessage, ex);
    }

    public static ApiException unauthorized(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.UNAUTHORIZED, messageSet);
    }

    public static ApiException unauthorized(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.UNAUTHORIZED, messageSet, ex);
    }

    public static ApiException conflict() {
        return new ApiException(HttpStatusCode.CONFLICT);
    }

    public static ApiException conflict(String message, String ... traits) {
        return new ApiException(HttpStatusCode.CONFLICT, message, traits);
    }

    public static ApiException conflict(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.CONFLICT, ex, traits);
    }

    public static ApiException conflict(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.CONFLICT, message, ex, traits);
    }

    public static ApiException conflict(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.CONFLICT, richMessage);
    }

    public static ApiException conflict(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.CONFLICT, richMessage, ex);
    }

    public static ApiException conflict(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.CONFLICT, messageSet);
    }

    public static ApiException conflict(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.CONFLICT, messageSet, ex);
    }

    public static ApiException notFound() {
        return new ApiException(HttpStatusCode.NOT_FOUND);
    }

    public static ApiException notFound(String message, String ... traits) {
        return new ApiException(HttpStatusCode.NOT_FOUND, message, traits);
    }

    public static ApiException notFound(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.NOT_FOUND, ex, traits);
    }

    public static ApiException notFound(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.NOT_FOUND, message, ex, traits);
    }

    public static ApiException notFound(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.NOT_FOUND, richMessage);
    }

    public static ApiException notFound(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.NOT_FOUND, richMessage, ex);
    }

    public static ApiException notFound(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.NOT_FOUND, messageSet);
    }

    public static ApiException notFound(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.NOT_FOUND, messageSet, ex);
    }

    public static ApiException badRequest() {
        return new ApiException(HttpStatusCode.BAD_REQUEST);
    }

    public static ApiException badRequest(String message, String ... traits) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, message, traits);
    }

    public static ApiException badRequest(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, ex, traits);
    }

    public static ApiException badRequest(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, message, ex, traits);
    }

    public static ApiException badRequest(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, richMessage);
    }

    public static ApiException badRequest(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, richMessage, ex);
    }

    public static ApiException badRequest(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, messageSet);
    }

    public static ApiException badRequest(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.BAD_REQUEST, messageSet, ex);
    }

    public static ApiException internalServerError() {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR);
    }

    public static ApiException internalServerError(String message, String ... traits) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, message, traits);
    }

    public static ApiException internalServerError(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, ex, traits);
    }

    public static ApiException internalServerError(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, message, ex, traits);
    }

    public static ApiException internalServerError(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, richMessage);
    }

    public static ApiException internalServerError(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, richMessage, ex);
    }

    public static ApiException internalServerError(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, messageSet);
    }

    public static ApiException internalServerError(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.INTERNAL_SERVER_ERROR, messageSet, ex);
    }

    public static ApiException serviceUnavailable() {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE);
    }

    public static ApiException serviceUnavailable(String message, String ... traits) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, message, traits);
    }

    public static ApiException serviceUnavailable(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, ex, traits);
    }

    public static ApiException serviceUnavailable(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, message, ex, traits);
    }

    public static ApiException serviceUnavailable(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, richMessage);
    }

    public static ApiException serviceUnavailable(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, richMessage, ex);
    }

    public static ApiException serviceUnavailable(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, messageSet);
    }

    public static ApiException serviceUnavailable(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.SERVICE_UNAVAILABLE, messageSet, ex);
    }

    public static ApiException preconditionFailed() {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED);
    }

    public static ApiException preconditionFailed(String message, String ... traits) {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED, message, traits);
    }

    public static ApiException preconditionFailed(Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED, ex, traits);
    }

    public static ApiException preconditionFailed(String message, Throwable ex, String ... traits) {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED, message, ex, traits);
    }

    public static ApiException preconditionFailed(FineMessage richMessage) {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED, richMessage);
    }

    public static ApiException preconditionFailed(FineMessage richMessage, Throwable ex) {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED, richMessage, ex);
    }

    public static ApiException preconditionFailed(FineMessageSet messageSet) {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED, messageSet);
    }

    public static ApiException preconditionFailed(FineMessageSet messageSet, Throwable ex) {
        return new ApiException(HttpStatusCode.PRECONDITION_FAILED, messageSet, ex);
    }
}

