/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.common.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNameFilter
implements FileFilter {
    private final Pattern pattern;
    private final boolean exclude;

    public FileNameFilter(Pattern pattern) {
        this(pattern, false);
    }

    public FileNameFilter(Pattern pattern, boolean exclude) {
        this.pattern = pattern;
        this.exclude = exclude;
    }

    public FileNameFilter(String nameRegEx) {
        this(Pattern.compile(nameRegEx), false);
    }

    public FileNameFilter(String nameRegEx, boolean exclude) {
        this(Pattern.compile(nameRegEx), exclude);
    }

    @Override
    public boolean accept(File file) {
        Matcher matcher = this.pattern.matcher(file.getName());
        if (this.isExclude()) {
            return !matcher.matches();
        }
        return matcher.matches();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isExclude() {
        return this.exclude;
    }
}

