package org.crazyyak.dev.couchace.app;

import com.couchace.core.api.*;
import com.couchace.jackson.JacksonCouchJsonStrategy;
import com.couchace.jersey.JerseyCouchHttpClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;

public class AppConfigCouchServer extends CouchServer {

  public AppConfigCouchServer(ObjectMapper mapper) {
    this(getCouchSetup(mapper));
  }

  public AppConfigCouchServer(CouchSetup couchSetup) {
    super(couchSetup);
    assertConnection();
  }

  private static CouchSetup getCouchSetup(ObjectMapper mapper) {

    String password = java.lang.System.getProperty("app-config-password");
    password = ExceptionUtils.assertNotNull(password, "app-config-password");

    JacksonCouchJsonStrategy jsonStrategy = new JacksonCouchJsonStrategy(mapper);

    return new CouchSetup("http://localhost:5984")
        .setUserName("app-config")
        .setPassword(password)
        .setHttpClient(JerseyCouchHttpClient.class)
        .setJsonStrategy(jsonStrategy);
  }
}
