// Copyright (c) 2010-2014, Munchie Monster, LLC.

package org.crazyyak.dev.couchace.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.*;
import java.util.*;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.crazyyak.dev.couchace.app.AppConfigCouchServer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.*;
import org.springframework.core.io.Resource;

public class CouchPropertyPlaceholderConfigurer extends PropertyPlaceholderConfigurer {

  private final Resource[] resources = new Resource[1];

  public CouchPropertyPlaceholderConfigurer(ObjectMapper objectMapper, AppConfigCouchServer couchServer, String entityName) throws MalformedURLException, URISyntaxException {
    ExceptionUtils.assertNotNull(couchServer, "couchServer");
    ExceptionUtils.assertNotNull(entityName, "entityName");

    AppConfigCouchServer server = new AppConfigCouchServer(objectMapper);

    CouchResourceLoader loader = new CouchResourceLoader(server);
    resources[0] = loader.getResource(entityName);
  }

  @Override
  public void setLocations(Resource[] resources) {
    System.out.printf("");
  }

  @Override
  public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    super.setLocations(resources);
    super.postProcessBeanFactory(beanFactory);
  }

  @Override
  protected void loadProperties(Properties props) throws IOException {
    super.loadProperties(props);

    for (Map.Entry<Object,Object> entry : props.entrySet()) {
      String key = entry.getKey().toString();
      if (key.startsWith("system.")) {
        key = key.substring(7);
        System.setProperty(key, (String) entry.getValue());
      }
    }
  }
}