/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.couchace.app;

import com.couchace.core.api.CouchServer;
import com.couchace.core.api.CouchSetup;
import com.couchace.core.spi.json.CouchJsonStrategy;
import com.couchace.jackson.JacksonCouchJsonStrategy;
import com.couchace.jersey.JerseyCouchHttpClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;

public class AppConfigCouchServer
extends CouchServer {
    public AppConfigCouchServer(ObjectMapper mapper) {
        this(AppConfigCouchServer.getCouchSetup(mapper));
    }

    public AppConfigCouchServer(CouchSetup couchSetup) {
        super(couchSetup);
        this.assertConnection();
    }

    private static CouchSetup getCouchSetup(ObjectMapper mapper) {
        String password = System.getProperty("app-config-password");
        password = (String)ExceptionUtils.assertNotNull((Object)password, (String)"app-config-password");
        JacksonCouchJsonStrategy jsonStrategy = new JacksonCouchJsonStrategy(mapper);
        return new CouchSetup("http://localhost:5984").setUserName("app-config").setPassword(password).setHttpClient(JerseyCouchHttpClient.class).setJsonStrategy((CouchJsonStrategy)jsonStrategy);
    }
}

