// Copyright (c) 2010-2014, Munchie Monster, LLC.
package org.crazyyak.dev.couchace.app;

import com.couchace.core.api.annotation.CouchEntity;import com.couchace.core.api.annotation.CouchId;import com.couchace.core.api.annotation.CouchRevision;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.StringWriter;import java.lang.String;

@CouchEntity(AppConfig.designName)
public class AppConfig {

  public static final String designName = "app-config";

  private String revision;

  private String appConfigId;

  private String[] properties;

  public AppConfig() {
  }

  @CouchId
  public String getAppConfigId() {
    return appConfigId;
  }

  @CouchRevision @JsonIgnore
  public String getRevision() {
    return revision;
  }

  public String[] getProperties() {
    return properties;
  }

  public String getPropertyString() {
    StringWriter writer = new StringWriter();

    for (String property : properties) {
      writer.write(property);
      writer.write("\n");
    }

    return writer.toString();
  }
}
