// Copyright (c) 2010-2014, Munchie Monster, LLC.
package org.crazyyak.dev.couchace.app;

import com.couchace.annotations.CouchEntity;
import com.couchace.annotations.CouchId;
import com.couchace.annotations.CouchRevision;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.StringWriter;import java.lang.String;

@CouchEntity("app-config")
public class AppConfig {

  private String revision;

  private String appConfigId;

  private String[] properties;

  public AppConfig() {
  }

  @CouchId
  public String getAppConfigId() {
    return appConfigId;
  }

  @CouchRevision
  @JsonIgnore
  public String getRevision() {
    return revision;
  }

  public String[] getProperties() {
    return properties;
  }

  public String getPropertyString() {
    StringWriter writer = new StringWriter();

    for (String property : properties) {
      writer.write(property);
      writer.write("\n");
    }

    return writer.toString();
  }
}
