// Copyright (c) 2010-2014, Munchie Monster, LLC.
package org.crazyyak.dev.couchace.app;

import com.couchace.core.api.CouchServer;
import org.crazyyak.dev.couchace.DefaultCouchStore;

public class AppConfigStore extends DefaultCouchStore<AppConfig> {

  public static final String DEFAULT_DB_NAME = "app-config";
  public static final String DEFAULT_DESIGN_NAME = "app-config";

  private String designName;

  public AppConfigStore(CouchServer couchServer) {
    this(couchServer, DEFAULT_DB_NAME, DEFAULT_DESIGN_NAME);
  }

  public AppConfigStore(CouchServer couchServer, String databaseName) {
    this(couchServer, databaseName, DEFAULT_DESIGN_NAME);
  }

  public AppConfigStore(CouchServer couchServer, String databaseName, String designName) {
    super(couchServer, databaseName, AppConfig.class);
    this.designName = designName;
  }

  @Override
  public String getDesignName() {
    return designName;
  }
}
