package org.crazyyak.app.demo.domain;

import java.util.List;
import org.crazyyak.app.demo.internal.DemoCouchServer;
import org.crazyyak.dev.couchace.DefaultCouchStore;

public class AccountStore extends DefaultCouchStore<Account> {

  public static final String ACCOUNT_DESIGN_NAME = "account";
  public AccountStore(DemoCouchServer couchServer, String databaseName) {
    super(couchServer, databaseName, Account.class);
  }

  @Override
  public String getDesignName() {
    return ACCOUNT_DESIGN_NAME;
  }

  public static String toDocumentId(String domainId) {
    return ACCOUNT_DESIGN_NAME+":"+domainId;
  }

  public List<Account> getAll() {
    return super.getEntities("allAccounts");
  }

  public Account getByEmailAddress(String emailAddress) {
    if (emailAddress == null) return null;
    List<Account> response = super.getEntities("byEmailAddress", emailAddress);
    return response.isEmpty() ? null : response.get(0);
  }

  public Account get(CurrentUser currentUser) {
    String documentId = toDocumentId(currentUser.getAccountId());
    return super.getByDocumentId(documentId);
  }
}
