package org.crazyyak.app.demo.internal;

import com.couchace.core.api.*;
import com.couchace.jackson.JacksonCouchJsonStrategy;
import com.couchace.jersey.JerseyCouchHttpClient;
import com.fasterxml.jackson.databind.ObjectMapper;

public class DemoCouchServer extends CouchServer {

  public DemoCouchServer(ObjectMapper mapper, String couchUrl, String couchUserName, String couchPassword) {
    super(getCouchSetup(mapper, couchUrl, couchUserName, couchPassword));
    super.assertConnection();
  }

  private static CouchSetup getCouchSetup(ObjectMapper mapper, String couchUrl, String couchUserName, String couchPassword) {

    JacksonCouchJsonStrategy jsonStrategy = new JacksonCouchJsonStrategy(mapper);

    return new CouchSetup(couchUrl)
        .setUserName(couchUserName)
        .setPassword(couchPassword)
        .setHttpClient(JerseyCouchHttpClient.class)
        .setJsonStrategy(jsonStrategy);
  }
}
