// Copyright (c) 2010-2013, Munchie Monster, LLC.
package org.crazyyak.app.demo.internal;

import org.crazyyak.app.demo.domain.*;
import org.crazyyak.dev.common.BeanUtils;
import org.springframework.security.authentication.*;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.*;

public class DemoSecurityProvider extends AbstractUserDetailsAuthenticationProvider {

  private final AccountStore accountStore;

  public DemoSecurityProvider(DemoCouchServer couchServer, String databaseName) {
    this.accountStore = new AccountStore(couchServer, databaseName);
  }

  @Override
  protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {

    if (BeanUtils.objectsNotEqual(userDetails.getUsername(), authentication.getPrincipal())) {
      throw new UsernameNotFoundException(Account.INVALID_USER_NAME_OR_PASSWORD);
    }

    if (BeanUtils.objectsNotEqual(userDetails.getPassword(), authentication.getCredentials())) {
      throw new BadCredentialsException(Account.INVALID_USER_NAME_OR_PASSWORD);
    }
  }

  @Override
  protected UserDetails retrieveUser(String userName, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {

    // We use an email address for the user name and
    // thus the disconnect between Account & UserDetails
    Account account = accountStore.getByEmailAddress(userName);

    if (account == null || BeanUtils.objectsNotEqual(account.getEmailAddress(), userName)) {
      throw new UsernameNotFoundException(Account.INVALID_USER_NAME_OR_PASSWORD);
    }

    return account.toUser();
  }
}
