/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.app.demo.domain;

import com.couchace.core.api.annotation.CouchEntity;
import com.couchace.core.api.annotation.CouchId;
import com.couchace.core.api.annotation.CouchRevision;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Set;
import org.crazyyak.app.demo.domain.AccountStatus;
import org.crazyyak.app.demo.domain.AccountStore;
import org.crazyyak.app.demo.domain.CurrentUser;
import org.crazyyak.app.demo.domain.Permissions;

@CouchEntity(value="account")
public class Account {
    public static final String INVALID_USER_NAME_OR_PASSWORD = "Invalid user name or password";
    private String accountId;
    private String revision;
    private String firstName;
    private String lastName;
    private String emailAddress;
    private String password;
    @JsonUnwrapped
    Permissions permissions;
    AccountStatus accountStatus;

    @JsonCreator
    public Account(@JsonProperty(value="accountId") String accountId, @JacksonInject(value="revision") String revision, @JsonProperty(value="emailAddress") String emailAddress, @JsonProperty(value="password") String password, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName) {
        this.accountId = accountId;
        this.revision = revision;
        this.emailAddress = emailAddress;
        this.password = password;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @JsonProperty
    public String getAccountId() {
        return this.accountId;
    }

    @CouchId
    @JsonIgnore
    public String getDocumentId() {
        return AccountStore.toDocumentId((String)this.accountId);
    }

    @CouchRevision
    @JsonIgnore
    public String getRevision() {
        return this.revision;
    }

    public Set<String> getRoleTypes() {
        return this.permissions.getRoleTypes();
    }

    public String getPassword() {
        return this.password;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public CurrentUser toUser() {
        return new CurrentUser(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Account) {
            Account that = (Account)object;
            return this.accountId.equals(that.accountId);
        }
        return false;
    }

    public String toString() {
        return this.emailAddress;
    }
}

