package org.crazyyak.app.demo.resources;

import javax.annotation.Resource;
import javax.servlet.http.*;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import org.apache.commons.logging.*;
import org.crazyyak.app.demo.domain.Account;
import org.crazyyak.app.demo.domain.AccountStore;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path("/")
@Resource
@Component
public class RootResource {

  private static final Log log = LogFactory.getLog(RootResource.class);

  private HttpServletRequest servletRequest;
  private HttpServletResponse servletResponse;
  private SecurityContext securityContext;
  private UriInfo uriInfo;
  private HttpHeaders headers;

  @Autowired
  private AccountStore accountStore;

  public RootResource() {
    log.info("Root resource loaded.");
  }

  @Context public void setServletRequest(HttpServletRequest servletRequest) {
    this.servletRequest = servletRequest;
  }
  @Context public void setServletResponse(HttpServletResponse servletResponse) {
    this.servletResponse = servletResponse;
  }
  @Context public void setSecurityContext(SecurityContext securityContext) {
    this.securityContext = securityContext;
  }
  @Context public void setUriInfo(UriInfo uriInfo) {
    this.uriInfo = uriInfo;
  }
  @Context public void setHeaders(HttpHeaders headers) {
    this.headers = headers;
  }

  public RequestConfig getRequestConfig() {
    return new RequestConfig(
        servletRequest,
        servletResponse,
        uriInfo,
        headers,
        securityContext,
        accountStore);
  }

  @GET
  @Produces(MediaType.TEXT_HTML)
  public Viewable getDefaultPage() {
    return renderHomePage(null);
  }

  @GET
  @Path("/signed-out")
  @Produces(MediaType.TEXT_HTML)
  public Viewable getSignedOut() {
    return renderHomePage("You have signed out.");
  }

  private Viewable renderHomePage(String message) {
    RequestConfig requestConfig = getRequestConfig();
    Account account = requestConfig.getAccount();
    return new Viewable("/index.jsp", new HomePageModel(account, message));
  }

  @Path("/admin")
  public AdminResource getAdminResource() {
    RequestConfig requestConfig = getRequestConfig();
    return new AdminResource(requestConfig);
  }

  @Path("/api")
  public ApiResource getApiResource() {
    RequestConfig requestConfig = getRequestConfig();
    return new ApiResource(requestConfig);
  }
}
