/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.app.demo.resources;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.app.demo.domain.Account;
import org.crazyyak.app.demo.domain.AccountStore;
import org.crazyyak.app.demo.resources.AdminResource;
import org.crazyyak.app.demo.resources.ApiResource;
import org.crazyyak.app.demo.resources.HomePageModel;
import org.crazyyak.app.demo.resources.RequestConfig;
import org.glassfish.jersey.server.mvc.Viewable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/")
@Resource
@Component
public class RootResource {
    private static final Log log = LogFactory.getLog(RootResource.class);
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private SecurityContext securityContext;
    private UriInfo uriInfo;
    private HttpHeaders headers;
    @Autowired
    private AccountStore accountStore;

    public RootResource() {
        log.info((Object)"Root resource loaded.");
    }

    @Context
    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    @Context
    public void setServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    @Context
    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Context
    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public RequestConfig getRequestConfig() {
        return new RequestConfig(this.servletRequest, this.servletResponse, this.uriInfo, this.headers, this.securityContext, this.accountStore);
    }

    @GET
    @Produces(value={"text/html"})
    public Viewable getDefaultPage() {
        return this.renderHomePage(null);
    }

    @GET
    @Path(value="/signed-out")
    @Produces(value={"text/html"})
    public Viewable getSignedOut() {
        return this.renderHomePage("You have signed out.");
    }

    private Viewable renderHomePage(String message) {
        RequestConfig requestConfig = this.getRequestConfig();
        Account account = requestConfig.getAccount();
        return new Viewable("/index.jsp", (Object)new HomePageModel(account, message));
    }

    @Path(value="/admin")
    public AdminResource getAdminResource() {
        RequestConfig requestConfig = this.getRequestConfig();
        return new AdminResource(requestConfig);
    }

    @Path(value="/api")
    public ApiResource getApiResource() {
        RequestConfig requestConfig = this.getRequestConfig();
        return new ApiResource(requestConfig);
    }
}

