package org.crazyyak.app.demo.internal;

import org.crazyyak.dev.jerseyspring.YakWebAppInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.core.annotation.Order;

// Order required to ensure this initializer is run
// before Jersey 2.x Spring WebApplicationInitializer
@Order(0)
public class DemoWebAppInitializer extends YakWebAppInitializer {

  public DemoWebAppInitializer() {
  }

  @Override
  public Class<? extends ResourceConfig> getApplicationClass() {
    return DemoApplication.class;
  }

  @Override
  public String getEnvironmentPropertyName() {
    return "yak.demo.env";
  }

  @Override
  public String getProfilesPropertyName() {
    return "yak.demo.profiles";
  }

  @Override
  protected String getSpringConfigLocation() {
    return "classpath:/demo-app/demo-app.xml";
  }
}