/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.app.demo.resources;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.crazyyak.app.demo.domain.Account;
import org.crazyyak.app.demo.domain.AccountStore;
import org.crazyyak.app.demo.domain.CurrentUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class RequestConfig {
    private final Account account;
    private final CurrentUser currentUser;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final UriInfo uriInfo;
    private HttpHeaders headers;
    private SecurityContext securityContext;
    private AccountStore accountStore;

    public RequestConfig(HttpServletRequest request, HttpServletResponse response, UriInfo uriInfo, HttpHeaders headers, SecurityContext securityContext, AccountStore accountStore) {
        Object principal;
        this.request = request;
        this.response = response;
        this.uriInfo = uriInfo;
        this.headers = headers;
        this.securityContext = securityContext;
        Account account = null;
        CurrentUser currentUser = null;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && (principal = auth.getPrincipal()) instanceof CurrentUser) {
            currentUser = (CurrentUser)principal;
            account = accountStore.get(currentUser);
        }
        this.account = account;
        this.currentUser = currentUser;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public AccountStore getAccountStore() {
        return this.accountStore;
    }

    public Account getAccount() {
        return this.account;
    }

    public CurrentUser getCurrentUser() {
        return this.currentUser;
    }
}

