package org.crazyyak.app.demo.resources;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import org.crazyyak.app.demo.domain.Account;

public class ApiResource {

  private RequestConfig requestConfig;

  public ApiResource(RequestConfig requestConfig) {
    this.requestConfig = requestConfig;
  }

  @GET
  @Path("/account/{emailAddress}")
  @Consumes(MediaType.APPLICATION_JSON)
  @Produces(MediaType.APPLICATION_JSON)
  public Account getDefault(@PathParam("emailAddress") String emailAddress) {
    return requestConfig.getAccount();
  }
}
