package org.crazyyak.app.demo.resources;

import javax.servlet.http.*;
import javax.ws.rs.core.*;
import org.crazyyak.app.demo.domain.*;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class RequestConfig {

  private final Account account;
  private final CurrentUser currentUser;

  private final HttpServletRequest request;
  private final HttpServletResponse response;

  private final UriInfo uriInfo;
  private HttpHeaders headers;
  private SecurityContext securityContext;

  private AccountStore accountStore;

  public RequestConfig(HttpServletRequest request, HttpServletResponse response, UriInfo uriInfo, HttpHeaders headers, SecurityContext securityContext, AccountStore accountStore) {
    this.request = request;
    this.response = response;
    this.uriInfo = uriInfo;

    this.headers = headers;
    this.securityContext = securityContext;

    Account account = null;
    CurrentUser currentUser = null;

    Authentication auth = SecurityContextHolder.getContext().getAuthentication();

    if (auth != null) {
      Object principal = auth.getPrincipal();
      if (principal instanceof CurrentUser) {
        currentUser = (CurrentUser)principal;
        account = accountStore.get(currentUser);
      }
    }

    this.account = account;
    this.currentUser = currentUser;
  }

  public HttpServletRequest getRequest() {
    return request;
  }

  public HttpServletResponse getResponse() {
    return response;
  }

  public UriInfo getUriInfo() {
    return uriInfo;
  }

  public HttpHeaders getHeaders() {
    return headers;
  }

  public SecurityContext getSecurityContext() {
    return securityContext;
  }

  public AccountStore getAccountStore() {
    return accountStore;
  }

  public Account getAccount() {
    return account;
  }

  public CurrentUser getCurrentUser() {
    return currentUser;
  }
}
