// Copyright (c) 2010-2013, Munchie Monster, LLC.
package org.crazyyak.app.demo.resources;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import org.crazyyak.app.demo.domain.Account;
import org.glassfish.jersey.server.mvc.Viewable;

public class AdminResource {

  private RequestConfig config;

  public AdminResource(RequestConfig config) {
    this.config = config;
  }

  @GET
  @Produces(MediaType.TEXT_HTML)
  public Viewable getDefault() {
    Account account = config.getAccount();
    AdminPageModel model = new AdminPageModel(account);
    return new Viewable("/admin/admin.jsp", model);
  }
}
