package org.crazyyak.app.demo.internal;

import org.apache.commons.logging.*;
import org.crazyyak.dev.domain.translation.jackson.jersey.JodaParamConverterProvider;
import org.crazyyak.dev.jerseyspring.YakExceptionMapper;
import org.crazyyak.dev.jerseyspring.YakJspMvcFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class DemoApplication extends ResourceConfig {

  private static final Log log = LogFactory.getLog(DemoApplication.class);

  public DemoApplication() {

    log.info("Demo application loaded.");

    property(YakJspMvcFeature.SUPPORTED_EXTENSIONS, "jsp, jspf");

    register(MultiPartFeature.class);
    register(YakJspMvcFeature.class);
    register(YakExceptionMapper.class);
    register(JodaParamConverterProvider.class);

    packages("org.crazyyak.app.demo");
  }
}
