/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.app.demo.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.crazyyak.app.demo.domain.Account;
import org.crazyyak.app.demo.resources.RequestConfig;
import org.joda.time.LocalDate;

public class ApiResource {
    private RequestConfig requestConfig;

    public ApiResource(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @GET
    @Path(value="/account/{emailAddress}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Account getDefault(@PathParam(value="emailAddress") String emailAddress) {
        return this.requestConfig.getAccountStore().getByEmailAddress(emailAddress);
    }

    @GET
    @Path(value="/date/{date}/month-of-year")
    @Produces(value={"application/json"})
    public int getCurrentDate(@PathParam(value="date") LocalDate localDate) {
        return localDate.getMonthOfYear();
    }
}

