/*
 * Copyright 2012 Jacob D Parr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.datatype.joda.JodaModule;

public class YakJacksonMapper extends ObjectMapper {

  public YakJacksonMapper() {
    // Stops LocalDateTime from being rendered as array.
    configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    // Pretty printing
    configure(SerializationFeature.INDENT_OUTPUT, true);

    // Empty strings to null
    configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);

    // Register Joda and Dev modules
    registerModule(new JodaModule());
    registerModule(new YakModule());

    // REVIEW We use NoFailInjectableValues to avoid errors when injectable (such as revision) are not found
    setInjectableValues(new NoFailInjectableValues());

    setVisibilityChecker(this.getSerializationConfig().getDefaultVisibilityChecker()
        .withFieldVisibility(JsonAutoDetect.Visibility.ANY)
        .withGetterVisibility(JsonAutoDetect.Visibility.NONE)
        .withSetterVisibility(JsonAutoDetect.Visibility.NONE)
        .withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
  }

  protected YakJacksonMapper(ObjectMapper src) {
    super(src);
  }

  @Override
  public ObjectMapper copy() {
    _checkInvalidCopy(YakJacksonMapper.class);
    return new YakJacksonMapper();
  }

}
