package org.crazyyak.dev.domain.translation.jackson.jersey;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.*;
import org.joda.time.*;
import org.joda.time.format.ISODateTimeFormat;

public class JodaParamConverterProvider implements ParamConverterProvider {

  public JodaParamConverterProvider() {
    super();
  }

  @Override
  public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {

    if (LocalDate.class.equals(rawType)) {
      // noinspection unchecked
      return (ParamConverter<T>)new LocalDateParamConverter();

    } else if (LocalTime.class.equals(rawType)) {
      // noinspection unchecked
      return (ParamConverter<T>)new LocalTimeParamConverter();

    } else if (LocalDateTime.class.equals(rawType)) {
      // noinspection unchecked
      return (ParamConverter<T>)new LocalDateTimeParamConverter();

    } else if (DateTime.class.equals(rawType)) {
      // noinspection unchecked
      return (ParamConverter<T>)new DateTimeParamConverter();

    } else if (DateMidnight.class.equals(rawType)) {
      // noinspection unchecked
      return (ParamConverter<T>)new DateMidnightParamConverter();
    }

    return null;
  }

  public static class LocalDateParamConverter implements ParamConverter<LocalDate> {
    @Override public LocalDate fromString(String value) {
      return new LocalDate(value);
    }
    @Override public String toString(LocalDate value) {
      return ISODateTimeFormat.date().print(value);
    }
  }

  public static class LocalTimeParamConverter implements ParamConverter<LocalTime> {
    @Override public LocalTime fromString(String value) {
      return new LocalTime(value);
    }
    @Override public String toString(LocalTime value) {
      return ISODateTimeFormat.time().print(value);
    }
  }

  public static class LocalDateTimeParamConverter implements ParamConverter<LocalDateTime> {
    @Override public LocalDateTime fromString(String value) {
      return new LocalDateTime(value);
    }
    @Override public String toString(LocalDateTime value) {
      return ISODateTimeFormat.dateTime().print(value);
    }
  }

  public static class DateMidnightParamConverter implements ParamConverter<DateMidnight> {
    @Override public DateMidnight fromString(String value) {
      return new DateMidnight(value);
    }
    @Override public String toString(DateMidnight value) {
      return ISODateTimeFormat.dateTime().print(value);
    }
  }

  public static class DateTimeParamConverter implements ParamConverter<DateTime> {
    @Override public DateTime fromString(String value) {
      return new DateTime(value);
    }
    @Override public String toString(DateTime value) {
      return ISODateTimeFormat.dateTime().print(value);
    }
  }

}
