/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.domain.money.Money;
import org.crazyyak.dev.domain.translation.jackson.MoneyDeserializer;
import org.crazyyak.dev.domain.translation.jackson.MoneySerializer;

public class YakModule
extends SimpleModule {
    public YakModule() {
        this.addSerializer((JsonSerializer)new MoneySerializer());
        this.addDeserializer(Money.class, (JsonDeserializer)new MoneyDeserializer());
        this.addSerializer((JsonSerializer)new StdSerializer<String>(String.class){

            public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                if (StringUtils.isBlank((Object)value)) {
                    jgen.writeNull();
                } else {
                    jgen.writeString(value);
                }
            }
        });
    }
}

