/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.translation.jersey;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.crazyyak.dev.domain.money.Money;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public abstract class BaseReaderWriterProvider
extends AbstractMessageReaderWriterProvider<Object> {
    private static final Log log = LogFactory.getLog(BaseReaderWriterProvider.class);
    protected boolean supportsArrays;
    protected boolean supportsEnums;
    protected boolean supportsPrimitives;
    protected final List<Class> supportedTypes = new ArrayList<Class>();
    protected final List<MediaType> mediaTypes = new ArrayList<MediaType>();

    protected BaseReaderWriterProvider(Collection<MediaType> mediaTypes) {
        this.mediaTypes.addAll(mediaTypes);
        this.supportsArrays = true;
        this.supportsEnums = true;
        this.supportsPrimitives = true;
        this.supportedTypes.add(String.class);
        this.supportedTypes.add(Number.class);
        this.supportedTypes.add(Collection.class);
        this.supportedTypes.add(Boolean.class);
        this.supportedTypes.add(Character.class);
        this.supportedTypes.add(Money.class);
        this.supportedTypes.add(DateMidnight.class);
        this.supportedTypes.add(DateTime.class);
        this.supportedTypes.add(Duration.class);
        this.supportedTypes.add(Instant.class);
        this.supportedTypes.add(LocalDateTime.class);
        this.supportedTypes.add(LocalDate.class);
        this.supportedTypes.add(LocalTime.class);
        this.supportedTypes.add(Period.class);
        this.supportedTypes.add(ReadableDateTime.class);
        this.supportedTypes.add(ReadableInstant.class);
        this.supportedTypes.add(Interval.class);
    }

    protected BaseReaderWriterProvider(Collection<Class> supportedTypes, Collection<MediaType> mediaTypes, boolean supportsArrays, boolean supportsEnums, boolean supportsPrimitives) {
        this.supportsArrays = supportsArrays;
        this.supportsEnums = supportsEnums;
        this.supportsPrimitives = supportsPrimitives;
        this.supportedTypes.addAll(supportedTypes);
    }

    public final boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupported(type, genericType, annotations, mediaType);
    }

    public final boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupported(type, genericType, annotations, mediaType);
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.mediaTypes.contains(mediaType)) {
            return false;
        }
        if (type.isArray() && !this.supportsArrays) {
            return false;
        }
        if (type.isPrimitive() && !this.supportsPrimitives) {
            return false;
        }
        if (type.isEnum() && !this.supportsEnums) {
            return false;
        }
        if (type.isArray()) {
            type = type.getComponentType();
        }
        for (Class supportedType : this.supportedTypes) {
            if (!supportedType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }
}

