/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.money;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.crazyyak.dev.domain.money.MoneyException;

public class Money
extends Number
implements Serializable,
Comparable<Money> {
    private static final String errorTemplate = String.format("The value %%s could not be converted to a %s: %%s", BigDecimal.class.getSimpleName());
    private static final DecimalFormat DollarFormat = new DecimalFormat("0.00");
    private long internalValue;

    @Deprecated
    public Money() {
        this.internalValue = 0L;
    }

    @Deprecated
    public Money(double value) {
        this(Money.convert(value));
    }

    @Deprecated
    public Money(double value, RoundingMode roundingMode) {
        this(Money.convert(value), roundingMode);
    }

    public Money(String value) {
        this(Money.convert(value));
    }

    public Money(String value, RoundingMode roundingMode) {
        this(Money.convert(value), roundingMode);
    }

    public Money(BigDecimal value) {
        this(value, RoundingMode.UNNECESSARY);
    }

    public Money(BigDecimal value, RoundingMode roundingMode) {
        try {
            BigDecimal newValue = value.setScale(2, roundingMode);
            newValue = newValue.multiply(new BigDecimal(100));
            newValue = newValue.setScale(2);
            this.internalValue = newValue.longValueExact();
        }
        catch (Throwable ex) {
            throw new MoneyException(String.format(errorTemplate, value, ex.getMessage()), ex);
        }
    }

    public Money(Money copy) {
        this.internalValue = copy.internalValue;
    }

    private static BigDecimal convert(String value) {
        try {
            value = value.replace(",", "").replace("$", "");
            return new BigDecimal(value);
        }
        catch (Throwable ex) {
            throw new MoneyException(String.format(errorTemplate, value), ex);
        }
    }

    private static BigDecimal convert(double value) {
        try {
            return BigDecimal.valueOf(value);
        }
        catch (Throwable ex) {
            throw new MoneyException(String.format(errorTemplate, value), ex);
        }
    }

    private Money(long internalValue) {
        this.internalValue = internalValue;
    }

    public long getInternalValue() {
        return this.internalValue;
    }

    public String getShortForm() {
        String retVal = this.toString();
        if (retVal.endsWith(".00")) {
            retVal = retVal.substring(0, retVal.length() - 3);
        }
        return retVal;
    }

    public String toString() {
        return DollarFormat.format(this.doubleValue());
    }

    public Money getAbsolute() {
        return this.isPositive() ? this : this.multiply(-1L);
    }

    public Money add(Money amount) {
        return this.plus(amount);
    }

    public Money plus(Money amount) {
        return new Money(this.internalValue + amount.getInternalValue());
    }

    public Money subtract(Money amount) {
        return this.minus(amount);
    }

    public Money minus(Money amount) {
        return new Money(this.internalValue - amount.getInternalValue());
    }

    public Money multiply(long multiplier) {
        long longValue = this.internalValue * multiplier;
        return new Money(longValue);
    }

    public Money multiply(double multiplier) {
        long longValue = (long)((double)this.internalValue * multiplier);
        return new Money(longValue);
    }

    public Money multiply(BigDecimal multiplier) {
        BigDecimal value = new BigDecimal(this.internalValue).divide(new BigDecimal(100));
        value = value.multiply(multiplier);
        return new Money(value, RoundingMode.HALF_EVEN);
    }

    public Money divide(double divisor) {
        long longValue = (long)((double)this.internalValue / divisor);
        return new Money(longValue);
    }

    public boolean equals(Object object) {
        if (object instanceof Money) {
            Money amount = (Money)object;
            return this.internalValue == amount.getInternalValue();
        }
        return false;
    }

    public boolean greaterThan(Money that) {
        return this.internalValue > that.getInternalValue();
    }

    public boolean lessThan(Money that) {
        return this.internalValue < that.getInternalValue();
    }

    public boolean isNegative() {
        return this.internalValue < 0L;
    }

    public boolean isNonNegative() {
        return !this.isNegative();
    }

    public boolean isPositive() {
        return this.internalValue > 0L;
    }

    public boolean isNonPositive() {
        return !this.isPositive();
    }

    public boolean isZero() {
        return this.internalValue == 0L;
    }

    public boolean isNonZero() {
        return this.internalValue != 0L;
    }

    public BigDecimal getWholeNumber() {
        BigDecimal value = new BigDecimal(this.internalValue / 100L);
        value = value.setScale(0, RoundingMode.HALF_EVEN);
        return value;
    }

    public BigDecimal getBigDecimalValue() {
        BigDecimal value = new BigDecimal((double)this.internalValue / 100.0);
        value = value.setScale(2, RoundingMode.HALF_EVEN);
        return value;
    }

    @Override
    public double doubleValue() {
        return this.getBigDecimalValue().doubleValue();
    }

    @Override
    public int intValue() {
        return this.getBigDecimalValue().intValue();
    }

    @Override
    public long longValue() {
        return this.getBigDecimalValue().longValue();
    }

    @Override
    public float floatValue() {
        return this.getBigDecimalValue().floatValue();
    }

    @Override
    public int compareTo(Money amount) {
        return this.getBigDecimalValue().compareTo(amount.getBigDecimalValue());
    }

    private static BigDecimal toBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException ex) {
            String msg = String.format("Cannot convert \"%s\" to an instance of %s.", value, Money.class.getSimpleName());
            throw new NumberFormatException(msg);
        }
    }

    public static Money ZERO() {
        return new Money("0.00");
    }

    public static Money MIN_VALUE() {
        return new Money(String.valueOf(Integer.MIN_VALUE));
    }

    public static Money MAX_VALUE() {
        return new Money(String.valueOf(Integer.MAX_VALUE));
    }

    public Money negate() {
        return this.multiply(new BigDecimal(-1));
    }
}

