/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.domain.translation.JsonTranslator;
import org.crazyyak.dev.domain.translation.jackson.YakJacksonObjectMapper;

public class YakJacksonTranslator
implements JsonTranslator {
    private final ObjectMapper jacksonMapper;

    public YakJacksonTranslator() {
        this(new YakJacksonObjectMapper());
    }

    public YakJacksonTranslator(ObjectMapper jacksonMapper) {
        this.jacksonMapper = jacksonMapper;
    }

    @Override
    public String toJson(Object domain) {
        try {
            return this.jacksonMapper.writeValueAsString(domain);
        }
        catch (JsonProcessingException e) {
            throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
        }
    }

    @Override
    public <T> T fromJson(Class<T> type, String json, Class<?> ... parameterTypes) {
        if (parameterTypes != null && parameterTypes.length > 0) {
            try {
                JavaType javaType = this.jacksonMapper.getTypeFactory().constructParametricType(type, (Class[])parameterTypes);
                return (T)this.jacksonMapper.readValue(json, type);
            }
            catch (IOException e) {
                throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
            }
        }
        try {
            return (T)this.jacksonMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw ApiException.internalServerError((Throwable)e, (String[])new String[0]);
        }
    }
}

