/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.crazyyak.dev.domain.translation.jackson.YakJacksonInjectable;
import org.crazyyak.dev.domain.translation.jackson.YakJacksonInjectableValues;
import org.crazyyak.dev.domain.translation.jackson.YakJacksonModule;

public class YakJacksonObjectMapper
extends ObjectMapper {
    private final Collection<? extends Module> modules;
    private final Collection<? extends YakJacksonInjectable> injectables;

    private static Collection<? extends Module> defaultModules() {
        return Arrays.asList(new SimpleModule[]{new JodaModule(), new YakJacksonModule()});
    }

    public YakJacksonObjectMapper() {
        this(YakJacksonObjectMapper.defaultModules(), Collections.emptyList());
    }

    public YakJacksonObjectMapper(Collection<? extends YakJacksonInjectable> injectables) {
        this(YakJacksonObjectMapper.defaultModules(), injectables);
    }

    public YakJacksonObjectMapper(Collection<? extends Module> modules, Collection<? extends YakJacksonInjectable> injectables) {
        this.modules = modules;
        this.injectables = injectables;
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, false);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        for (Module module : modules) {
            this.registerModule(module);
        }
        YakJacksonInjectableValues injectableValues = new YakJacksonInjectableValues();
        for (YakJacksonInjectable yakJacksonInjectable : injectables) {
            injectableValues.addValue(yakJacksonInjectable.getKey(), yakJacksonInjectable.getValue());
        }
        this.setInjectableValues((InjectableValues)injectableValues);
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(YakJacksonObjectMapper.class);
        return new YakJacksonObjectMapper(this.getModules(), this.getInjectables());
    }

    public Collection<? extends Module> getModules() {
        return Collections.unmodifiableCollection(this.modules);
    }

    public Collection<? extends YakJacksonInjectable> getInjectables() {
        return Collections.unmodifiableCollection(this.injectables);
    }
}

