/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.locality;

import org.crazyyak.dev.common.StringUtils;
import org.crazyyak.dev.common.exceptions.ExceptionUtils;
import org.crazyyak.dev.domain.locality.Country;
import org.crazyyak.dev.domain.locality.State;

public class LatLng {
    private String latitude;
    private String longitude;
    private String city;
    private State state;
    private Country country;
    private String label;

    public LatLng(String latitude, String longitude) {
        this(latitude, longitude, null, null, null);
    }

    public LatLng(String latitude, String longitude, String city, State state, Country country) {
        this(latitude, longitude, city, state, country, null);
    }

    public LatLng(String latitude, String longitude, String city, State state, Country country, String label) {
        ExceptionUtils.assertNotNull((Object)latitude, (String)"latitude");
        ExceptionUtils.assertNotNull((Object)longitude, (String)"longitude");
        this.latitude = latitude;
        this.longitude = longitude;
        this.city = city;
        this.state = state;
        this.country = country;
        this.label = label != null ? label : LatLng.buildLabel(latitude, longitude, city, state, country);
    }

    public static String buildLabel(String latitude, String longitude, String city, State state, Country country) {
        if (StringUtils.isNotBlank((Object[])new Object[]{city}) && StringUtils.isNotBlank((Object[])new Object[]{state})) {
            if (StringUtils.isNotBlank((Object[])new Object[]{country}) || Country.US.equals((Object)country)) {
                return city + ", " + state;
            }
            return city + ", " + state + " " + (Object)((Object)country);
        }
        return latitude + ", " + longitude;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCity() {
        return this.city;
    }

    public State getState() {
        return this.state;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public double getLatitudeDouble() {
        return Double.valueOf(this.latitude);
    }

    public double getLongitudeDouble() {
        return Double.valueOf(this.longitude);
    }

    public double between(LatLng that) {
        double earthRadius = 3958.75;
        double dLat = Math.toRadians(that.getLatitudeDouble() - this.getLatitudeDouble());
        double dLng = Math.toRadians(that.getLongitudeDouble() - this.getLongitudeDouble());
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(this.getLatitudeDouble())) * Math.cos(Math.toRadians(that.getLatitudeDouble())) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return earthRadius * c;
    }

    public boolean equals(Object object) {
        if (object instanceof LatLng) {
            LatLng that = (LatLng)object;
            return this.latitude.equals(that.latitude) && this.longitude.equals(that.longitude);
        }
        return false;
    }

    public String toString() {
        return this.label;
    }
}

