/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.crazyyak.dev.domain.translation.jackson.YakJacksonInjectable;
import org.crazyyak.dev.domain.translation.jackson.YakJacksonInjectableValues;
import org.crazyyak.dev.domain.translation.jackson.YakJacksonModule;

public class YakJacksonObjectMapper
extends ObjectMapper {
    private final Collection<? extends Module> modules;
    private final Collection<? extends YakJacksonInjectable> injectables;

    public YakJacksonObjectMapper() {
        this(Arrays.asList(new SimpleModule[]{new JodaModule(), new YakJacksonModule()}), Collections.emptyList());
    }

    public YakJacksonObjectMapper(Collection<? extends Module> modules, Collection<? extends YakJacksonInjectable> injectables) {
        this.modules = modules;
        this.injectables = injectables;
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, false);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        for (Module module : modules) {
            this.registerModule(module);
        }
        YakJacksonInjectableValues injectableValues = new YakJacksonInjectableValues();
        for (YakJacksonInjectable yakJacksonInjectable : injectables) {
            injectableValues.addValue(yakJacksonInjectable.getKey(), yakJacksonInjectable.getValue());
        }
        this.setInjectableValues((InjectableValues)injectableValues);
        this.setVisibilityChecker(this.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.ANY).withCreatorVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(YakJacksonObjectMapper.class);
        return new YakJacksonObjectMapper(this.modules, this.injectables);
    }
}

