/*
 * Copyright 2014 Harlan Noonkester
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.annotation.*;
import org.crazyyak.dev.common.fine.FineMessage;
import org.crazyyak.dev.common.fine.ImmutableFineMessageSet;
import org.crazyyak.dev.common.fine.ImmutableFineMessageSetBuilder;

import java.util.Collection;

/**
 * User: harlann
 * Date: 8/25/13
 * Time: 12:56 AM
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NONE, defaultImpl= ImmutableFineMessageSet.class)
public abstract class FineMessageSetMixin {

  @JsonCreator
  public FineMessageSetMixin(@JsonProperty("messages") Collection<? extends FineMessage> messages) {
  }

  @JsonIgnore public abstract boolean isEmpty();
  @JsonIgnore public abstract int isNotEmpty();
}

