/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.locality;

import org.crazyyak.dev.domain.locality.Province;

public enum State implements Province
{
    AL("Alabama"),
    AK("Alaska"),
    AZ("Arizona"),
    AR("Arkansas"),
    CA("California"),
    CO("Colorado"),
    CT("Connecticut"),
    DE("Delaware"),
    FL("Florida"),
    GA("Georgia"),
    HI("Hawaii"),
    ID("Idaho"),
    IL("Illinois"),
    IN("Indiana"),
    IA("Iowa"),
    KS("Kansas"),
    KY("Kentucky"),
    LA("Louisiana"),
    ME("Maine"),
    MD("Maryland"),
    MA("Massachusetts"),
    MI("Michigan"),
    MN("Minnesota"),
    MS("Mississippi"),
    MO("Missouri"),
    MT("Montana"),
    NE("Nebraska"),
    NV("Nevada"),
    NH("New Hampshire"),
    NJ("New Jersey"),
    NM("New Mexico"),
    NY("New York"),
    NC("North Carolina"),
    ND("North Dakota"),
    OH("Ohio"),
    OK("Oklahoma"),
    OR("Oregon"),
    PA("Pennsylvania"),
    RI("Rhode Island"),
    SC("South Carolina"),
    SD("South Dakota"),
    TN("Tennessee"),
    TX("Texas"),
    UT("Utah"),
    VT("Vermont"),
    VA("Virginia"),
    WA("Washington"),
    WV("West Virginia"),
    WI("Wisconsin"),
    WY("Wyoming"),
    AS("American Samoa"),
    DC("District of Columbia"),
    FM("Federated States of Micronesia"),
    GU("Guam"),
    MH("Marshall Islands"),
    MP("Northern Mariana Islands"),
    PW("Palau"),
    PR("Puerto Rico"),
    VI("Virgin Islands");

    private String description;

    private State(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getAbbreviation() {
        return this.name();
    }

    public String toString() {
        return this.description;
    }

    public static State toState(String descriptionOrAbbreviation) {
        if (descriptionOrAbbreviation == null) {
            return null;
        }
        for (State state : State.values()) {
            if (!state.getDescription().equals(descriptionOrAbbreviation) && !state.getAbbreviation().equals(descriptionOrAbbreviation)) continue;
            return state;
        }
        return null;
    }

    public static State valueOf(String code, State defaultValue) {
        try {
            return State.valueOf(code);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

