/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.validation;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.crazyyak.dev.common.exceptions.ApiException;
import org.crazyyak.dev.common.fine.FineMessageSet;
import org.crazyyak.dev.common.fine.FineMessageSetBuilder;
import org.crazyyak.dev.common.fine.TraitMap;
import org.crazyyak.dev.common.net.HttpStatusCode;
import org.crazyyak.dev.domain.validation.BeanValidator;

public class Jsr349BeanValidator
implements BeanValidator {
    private final Validator validator;

    public Jsr349BeanValidator(Validator validator) {
        this.validator = validator;
    }

    public Jsr349BeanValidator(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    @Override
    public FineMessageSet validate(Object object, Class<?> ... groups) {
        Set violations = this.validator.validate(object, (Class[])groups);
        return this.newFineMessageSet(violations);
    }

    @Override
    public void validateWithThrow(Object object, Class<?> ... groups) {
        Set violations = this.validator.validate(object, (Class[])groups);
        FineMessageSet messageSet = this.newFineMessageSet(violations);
        if (messageSet.isNotEmpty()) {
            throw ApiException.badRequest((FineMessageSet)messageSet);
        }
    }

    @Override
    public void validateWithThrow(Object object, HttpStatusCode statusCode, Class<?> ... groups) {
        Set violations = this.validator.validate(object, (Class[])groups);
        FineMessageSet messageSet = this.newFineMessageSet(violations);
        if (messageSet.isNotEmpty()) {
            throw new ApiException(statusCode, messageSet);
        }
    }

    @Override
    public FineMessageSet validateProperty(Object object, String propertyName, Class<?> ... groups) {
        Set violations = this.validator.validateProperty(object, propertyName, (Class[])groups);
        return this.newFineMessageSet(violations);
    }

    protected FineMessageSet newFineMessageSet(Set<ConstraintViolation<Object>> violations) {
        FineMessageSetBuilder builder = new FineMessageSetBuilder();
        for (ConstraintViolation<Object> violation : violations) {
            String text = violation.getMessage();
            String propertyPath = violation.getPropertyPath().toString();
            if (propertyPath != null && !propertyPath.isEmpty()) {
                builder.withAll(text, propertyPath, new TraitMap(new String[]{"property:" + propertyPath}));
                continue;
            }
            builder.withText(text);
        }
        return builder.build();
    }

    public Validator getValidator() {
        return this.validator;
    }
}

