/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.domain.translation.jackson;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class NoFailInjectableValues
extends InjectableValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, Object> valueMap = new HashMap<String, Object>();

    public void addValue(String key, Object value) {
        this.valueMap.put(key, value);
    }

    public void addValue(Class<?> classKey, Object value) {
        this.valueMap.put(classKey.getName(), value);
    }

    @Override
    public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) {
        if (!(valueId instanceof String)) {
            String type = valueId == null ? "[null]" : valueId.getClass().getName();
            throw new IllegalArgumentException("Unrecognized inject value id type (" + type + "), expecting String");
        }
        String key = (String)valueId;
        return this.valueMap.get(key);
    }
}

