/*
 * Decompiled with CFR 0.152.
 */
package org.crazyyak.dev.embedded.jetty;

import org.crazyyak.dev.domain.embedded.EmbeddedAction;
import org.crazyyak.dev.domain.embedded.EmbeddedArgs;
import org.crazyyak.dev.domain.embedded.EmbeddedStatus;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class EmbeddedJetty {
    private static final Logger LOG = Log.getLogger(EmbeddedJetty.class);
    public static final String __containerIncludeJarPattern = ".*/.*jsp-api-[^/]*\\.jar$|.*/.*jsp-[^/]*\\.jar$|.*/.*taglibs[^/]*\\.jar$|.*/.*jstl[^/]*\\.jar$|.*/.*jsf-impl-[^/]*\\.jar$|.*/.*javax.faces-[^/]*\\.jar$|.*/.*myfaces-impl-[^/]*\\.jar$|.*/.*jetty-runner-[^/]*\\.jar$";
    private EmbeddedArgs embeddedArgs;

    public EmbeddedJetty(EmbeddedArgs embeddedArgs) {
        this.embeddedArgs = embeddedArgs;
    }

    public static void main(String ... args) {
        try {
            EmbeddedArgs embeddedArgs = new EmbeddedArgs(args);
            if (embeddedArgs.getErrorMessage() != null) {
                System.out.println(embeddedArgs.getErrorMessage());
                EmbeddedArgs.printUsage();
                System.out.flush();
                return;
            }
            int exitCode = EmbeddedAction.stop == embeddedArgs.getAction() ? EmbeddedJetty.shutdown(embeddedArgs.getShutdownPort(), embeddedArgs.getShutdownTimeout()) : (EmbeddedAction.status == embeddedArgs.getAction() ? EmbeddedJetty.getStatus(embeddedArgs.getShutdownPort()).getExitCode() : new EmbeddedJetty(embeddedArgs).start(true, embeddedArgs.isAutoShutDown()));
            System.exit(exitCode);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            EmbeddedArgs.printUsage();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static EmbeddedStatus getStatus(int shutdownPort) {
        return null;
    }

    public static int shutdown(int shutdownPort, int shutdownTimeout) {
        return 0;
    }

    public int start(boolean keepAlive, boolean autoShutDown) throws Exception {
        try {
            Server server = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(8080);
            server.addConnector(connector);
            WebAppContext webapp = new WebAppContext();
            webapp.setContextPath("/");
            webapp.setWar(this.embeddedArgs.getWebAppRoot());
            webapp.setParentLoaderPriority(true);
            webapp.setConfigurations(new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration(), new PlusConfiguration(), new AnnotationConfiguration(), new JettyWebXmlConfiguration(), new TagLibConfiguration()});
            server.setHandler(webapp);
            server.start();
            server.join();
            return 0;
        }
        catch (Throwable e) {
            System.out.printf("Embedded-Jetty application start failed.\n", new Object[0]);
            throw e;
        }
    }
}

