/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalDateTimeSerializer
extends JodaSerializerBase<LocalDateTime> {
    static final DateTimeFormatter format = ISODateTimeFormat.dateTime();

    public LocalDateTimeSerializer() {
        super(LocalDateTime.class);
    }

    @Override
    public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeNumber(localDateTime.year().get());
            jsonGenerator.writeNumber(localDateTime.monthOfYear().get());
            jsonGenerator.writeNumber(localDateTime.dayOfMonth().get());
            jsonGenerator.writeNumber(localDateTime.hourOfDay().get());
            jsonGenerator.writeNumber(localDateTime.minuteOfHour().get());
            jsonGenerator.writeNumber(localDateTime.secondOfMinute().get());
            jsonGenerator.writeNumber(localDateTime.millisOfSecond().get());
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(format.print(localDateTime));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode(serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) ? "array" : "string", true);
    }
}

