package org.crazyyak.dev.embedded.jetty;

import org.crazyyak.dev.domain.embedded.*;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.*;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.*;
import org.eclipse.jetty.webapp.*;

public class EmbeddedJetty {

  private static final Logger LOG = Log.getLogger(EmbeddedJetty.class);

/*
  public static final String[] __plusConfigurationClasses = new String[] {
          org.eclipse.jetty.webapp.WebInfConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.webapp.WebXmlConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.webapp.MetaInfConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.webapp.FragmentConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.plus.webapp.EnvConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.plus.webapp.PlusConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.annotations.AnnotationConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.webapp.JettyWebXmlConfiguration.class.getCanonicalName(),
          org.eclipse.jetty.webapp.TagLibConfiguration.class.getCanonicalName()
          };
*/

  public static final String __containerIncludeJarPattern = ".*/.*jsp-api-[^/]*\\.jar$|.*/.*jsp-[^/]*\\.jar$|.*/.*taglibs[^/]*\\.jar$|.*/.*jstl[^/]*\\.jar$|.*/.*jsf-impl-[^/]*\\.jar$|.*/.*javax.faces-[^/]*\\.jar$|.*/.*myfaces-impl-[^/]*\\.jar$|.*/.*jetty-runner-[^/]*\\.jar$";

/*
  protected Server _server;
  protected org.mortbay.jetty.runner.Monitor _monitor;
  protected URLClassLoader _classLoader;
  protected List<URL> _classpath=new ArrayList<URL>();
  protected ContextHandlerCollection _contexts;
  protected RequestLogHandler _logHandler;
  protected String _logFile;
  protected String _configFile;
  protected UserTransaction _ut;
  protected String _utId;
  protected String _txMgrPropertiesFile;
  protected Random _random = new Random();
  protected boolean _isTxServiceAvailable=false;
  protected boolean _enableStatsGathering=false;
  protected String _statsPropFile;
  protected boolean _clusteredSessions=true;
*/

  private EmbeddedArgs embeddedArgs;

  public EmbeddedJetty(EmbeddedArgs embeddedArgs) {
    this.embeddedArgs = embeddedArgs;
  }

  public static void main(String...args) {
    try {

      EmbeddedArgs embeddedArgs = new EmbeddedArgs(args);

      if (embeddedArgs.getErrorMessage() != null) {
        System.out.println(embeddedArgs.getErrorMessage());
        EmbeddedArgs.printUsage();
        System.out.flush();
        return;
      }

      int exitCode;

      if (EmbeddedAction.stop == embeddedArgs.getAction()) {
        exitCode = EmbeddedJetty.shutdown(
            embeddedArgs.getShutdownPort(),
            embeddedArgs.getShutdownTimeout());

      } else if (EmbeddedAction.status == embeddedArgs.getAction()) {
        exitCode = EmbeddedJetty.getStatus(embeddedArgs.getShutdownPort()).getExitCode();

      } else {
        exitCode = new EmbeddedJetty(embeddedArgs).start(true, embeddedArgs.isAutoShutDown());
      }

      System.exit(exitCode);

    } catch (IllegalArgumentException e) {
      System.out.println(e.getMessage());
      EmbeddedArgs.printUsage();
      System.exit(0);

    } catch (Exception e) {
      e.printStackTrace();
      System.exit(0);
    }
  }

  public static EmbeddedStatus getStatus(int shutdownPort) {
    return null;
  }

  public static int shutdown(int shutdownPort, int shutdownTimeout) {
    return 0;
  }

  public int start(boolean keepAlive, boolean autoShutDown) throws Exception {
    try {

      Server server = new Server();

      SelectChannelConnector connector = new SelectChannelConnector();
      connector.setPort(8080);
      server.addConnector(connector);

      WebAppContext webapp = new WebAppContext();
      webapp.setContextPath("/");
      webapp.setWar(embeddedArgs.getWebAppRoot());

      webapp.setParentLoaderPriority(true);

      webapp.setConfigurations(
        new Configuration[] {
          new WebInfConfiguration(),
          new WebXmlConfiguration(),
          new MetaInfConfiguration(),
          new FragmentConfiguration(),
          new EnvConfiguration(),
          new PlusConfiguration(),
          new AnnotationConfiguration(),
          new JettyWebXmlConfiguration(),
          new TagLibConfiguration()
        }
      );

      server.setHandler(webapp);

      server.start();
      server.join();


      return 0;

    } catch(Throwable e) {
      System.out.printf("Embedded-Jetty application start failed.\n");
      throw e;
    }
  }
}
