/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.DateMidnight;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateMidnightSerializer
extends JodaSerializerBase<DateMidnight> {
    static final DateTimeFormatter format = ISODateTimeFormat.date();

    public DateMidnightSerializer() {
        super(DateMidnight.class);
    }

    @Override
    public void serialize(DateMidnight dateMidnight, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeNumber(dateMidnight.year().get());
            jsonGenerator.writeNumber(dateMidnight.monthOfYear().get());
            jsonGenerator.writeNumber(dateMidnight.dayOfMonth().get());
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(format.print(dateMidnight));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode(serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) ? "array" : "string", true);
    }
}

